package Enigma.model;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/**
 * Hier sitzt der Funker
 * Der Funkraum kann Funksprüche empfangen und senden.
 * Hierfür wird eine Verbindung zu einem externen Service aufgebaut.
 * Dieser Servive erwartet die Nachrichten im JSON Format. Dazu wird ein k als Kenngruppe
 * (Benutzername) übergeben und falls eine Nachricht gesendet werden soll, zusätzlich ein m mit der Nachricht.
 * Beides wird als String gesendet.
 */
public class Funkraum {
	/**
	 * Zum Empfangen liefert der Server, anstatt der Kenngruppe (k) den Empfangstag der Nachricht mit damit man
	 *  die Grundeinstellungen aus dem Codebuch, für diesen Tag, raussuchen kann.
	 *  {'m': 'Hello world', 't': '26'}
	 *
	 * @param kenngruppe : String : Kenngruppe dieser Engiam
	 * @return String[] : String Array wobei Index 0 dem Empfangstag entspricht und index 1 der empfangenen Nachricht
	 * @throws IOException : Exception :  wenn keine Verbindung zum Funker aufgebaut werden konnte.
	 */
	public String[] empfangeFunkspruch(String kenngruppe) throws IOException {
		String[] funkspruch = new String[2];

		HttpClient httpclient = HttpClients.createDefault();
		HttpPost httppost = new HttpPost("https://enigma.itstall.de/");

		// Anfrage Parameter und Encoding setzen
		List<NameValuePair> params = new ArrayList<>(2);
		params.add(new BasicNameValuePair("k", kenngruppe));
		httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

		// POST Request ausführen und Rückgabe verarbeiten
		HttpResponse response = httpclient.execute(httppost);
		HttpEntity entity = response.getEntity();

		if (entity != null) {
			BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
			JSONObject result = new JSONObject(reader.readLine());

			if(!result.getString("m").isEmpty()) {
				funkspruch[0] = result.getString("t");
				funkspruch[1] = result.getString("m");
			}
		}

		return funkspruch;
	}

	/**
	 * Dem Service senden wir unsere Nachricht als POST Parameter (m) und unsere Kenngruppe (k).
	 * Dieser nimmt die Daten entgegeb und hierlerlegt sie auf seinem Stapel (Datenbank) von dem die Nachrichten
	 * irgendwann, auf Anfrage, wieder abgerufen werden können.
	 *
	 *  Darauf antworter der Server dann mit einem JSON Object in dem das Ergebnis der Anfrage zu sehen ist.
	 *  {'result': 200}
	 *
	 *  Die 200 heißt hier das alles erfolgreich durchgeführt werden konnte. Steht hier etwas anderes, ist ein Fehler
	 *  aufgetreten und die Anfrage war nicht erfolgreich.
	 *  In letzterem Fall sollte eine Meldung an den Benutzer ausgegeben werden und ggF später erneut versucht.
	 *
	 * @param funkspruch : String : Der zu sendede Funkspruch
	 * @param kenngruppe : String : Die Kenngruppe dieser Engima
	 * @throws IOException : Exception : Funkspruch konnte nicht gesendet werden
	 */
	public void sendeFunkspruch(String funkspruch, String kenngruppe) throws HttpException, IOException {
		HttpClient httpclient = HttpClients.createDefault();
		HttpPost httppost = new HttpPost("https://enigma.itstall.de/");

		// Anfrage Parameter und Encoding setzen
		List<NameValuePair> params = new ArrayList<>(2);
		params.add(new BasicNameValuePair("k", kenngruppe));
		params.add(new BasicNameValuePair("m", funkspruch));
		httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

		// POST Request ausführen und Rückgabe verarbeiten
		HttpResponse response = httpclient.execute(httppost);
		HttpEntity entity = response.getEntity();

		if (entity != null) {
			BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
			JSONObject result = new JSONObject(reader.readLine());
			if(result.getInt("result") != 200) {
				throw new HttpException("Der andere Funker mag deine Nachricht nicht. Rüge ihn wenn du ihn wieder siehst...");
			}
		}

	}
}
