package projekt.enigma.model;

import org.junit.Assert;
import org.junit.Test;

public class HardwareTest {

	@Test
	public void tippeBuchstabe() {

		Hardware h = new Hardware();
		h.setReflektor(new Reflektor());
		h.setSteckbrett(new Steckbrett());
		h.setWalzen(0, 1, 1);
		h.setWalzen(1, 2, 1);
		h.setWalzen(2, 3, 1);

		/*
        Walze nach der Chiffrierung
        Alphabet    {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        Steckbrett  {'B', 'G', 'D', 'F'}
        Steckbrett  {'G', 'B', 'F', 'F'}
    Walze 3    {'B', 'D', 'F', 'H', 'J', 'L', 'C', 'P', 'R', 'T', 'X', 'V', 'Z', 'N', 'Y', 'E', 'I', 'W', 'G', 'A', 'K', 'M', 'U', 'S', 'Q', 'O'};
		Walze 2     {'A', 'J', 'D', 'K', 'S', 'I', 'R', 'U', 'X', 'B', 'L', 'H', 'W', 'T', 'M', 'C', 'Q', 'G', 'Z', 'N', 'P', 'Y', 'F', 'V', 'O', 'E'};
		Walze 1     {'E', 'K', 'M', 'F', 'L', 'G', 'D', 'Q', 'V', 'Z', 'N', 'T', 'O', 'W', 'Y', 'H', 'X', 'U', 'S', 'P', 'A', 'I', 'B', 'R', 'C', 'J'};
        Reflektor   {'E', 'J', 'M', 'Z', 'A', 'L', 'Y', 'X', 'V', 'B', 'W', 'F', 'C', 'R', 'Q', 'U', 'O', 'N', 'T', 'S', 'P', 'I', 'K', 'H', 'G', 'D'};
		*/

		char result;
		h.resetWalzen();
		result = h.codiere('A');
		Assert.assertEquals("Codiere: A Erwartet P, erhalten " + result, 'P', result);
		result = h.codiere('B');
		Assert.assertEquals("Codiere: B Erwartet R, erhalten " + result, 'R', result);
		result = h.codiere('I');
		Assert.assertEquals("Codiere: I Erwartet E, erhalten " + result, 'E', result);
		result = h.codiere('F');
		Assert.assertEquals("Codiere: F Erwartet A, erhalten " + result, 'A', result);

		h.resetWalzen();
		result = h.codiere('P');
		Assert.assertEquals("Decodiere: P Erwartet A, erhalten " + result, 'A', result);
		result = h.codiere('R');
		Assert.assertEquals("Decodiere: R Erwartet B, erhalten " + result, 'B', result);
		result = h.codiere('E');
		Assert.assertEquals("Decodiere: E Erwartet I, erhalten " + result, 'I', result);
		result = h.codiere('A');
		Assert.assertEquals("Decodiere: A Erwartet F, erhalten " + result, 'F', result);

		h.resetWalzen();
		h.getSteckbrett().setzeVertauschung('B', 'G');
		h.getSteckbrett().setzeVertauschung('D', 'F');
		h.getSteckbrett().setzeVertauschung('I', 'L');
		h.getSteckbrett().setzeVertauschung('M', 'Q');
		h.getSteckbrett().setzeVertauschung('T', 'X');

		result = h.codiere('I');
		Assert.assertEquals("Codiere: Erwartet F, erhalten " + result, 'D', result);

		h.resetWalzen();
		result = h.codiere('D');
		Assert.assertEquals("Codiere: Erwartet I, erhalten " + result, 'I', result);
	}
}