package projekt.enigma.model;

/**
 * Klasse Walze
 * <p>
 * Erzeugt ein Objekt des Typs Walze mit den Eigenschaften:
 * <p>
 * 1. Walzennummer (Die Walze enthält die 26 Buchstaben des Alphabeths und codiert diese.
 * 5 verschiedene Walzen stehen zur Auswahl, die jeweils verschieden die Buchstaben des Alphabeths
 * paarweise vertauschen)
 * <p>
 * 2. Ringstellung (Umspringpunkt der Walze wird festgelegt. Der Umspringpunkt bestimmt
 * den Drehzeitpunkt der linken Nachbarwalze)
 */
public class Walze {

	/**
	 * Konstanten und Variablen der Klasse Walze
	 * <p>
	 * ringstellung : Bestimmt den Umspringpunkt der Walze
	 * walzennr : Bestimmt die Walzennr. (also wie der Buchstabe codiert wird)
	 */
	private Character[] walzeAlpha;
	private char ringstellung;
	private int walzennr;
	private Character[] alphabet;


	/**
	 * Gibt die Parameter der Walze mit
	 *
	 * @param walzennr     : int : Nummer der gewaehlten Walze
	 * @param ringstellung : Character : Einstellung des Notch
	 */
	public Walze(int walzennr, int ringstellung) {
		this.alphabet = new Character[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
		this.walzeAlpha = new Character[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

		// Setzen der Walzennummer
		this.setWalzennr(walzennr);

		// Setzen der Ringstellung
		this.setRingstellung(ringstellung);
	}

	/**
	 * Sortiert den Walzennummern das passenden Character-Array mittels switch zu.
	 *
	 * @return walze : Character[] : gibt die gewaehlte Walze zurueck
	 */
	private Character[] walzenNummer() {

		Character[] walze = new Character[26];
		Character[] walzeEins = {'E', 'K', 'M', 'F', 'L', 'G', 'D', 'Q', 'V', 'Z', 'N', 'T', 'O', 'W', 'Y', 'H', 'X', 'U', 'S', 'P', 'A', 'I', 'B', 'R', 'C', 'J'};
		Character[] walzeZwei = {'A', 'J', 'D', 'K', 'S', 'I', 'R', 'U', 'X', 'B', 'L', 'H', 'W', 'T', 'M', 'C', 'Q', 'G', 'Z', 'N', 'P', 'Y', 'F', 'V', 'O', 'E'};
		Character[] walzeDrei = {'B', 'D', 'F', 'H', 'J', 'L', 'C', 'P', 'R', 'T', 'X', 'V', 'Z', 'N', 'Y', 'E', 'I', 'W', 'G', 'A', 'K', 'M', 'U', 'S', 'Q', 'O'};
		Character[] walzeVier = {'E', 'S', 'O', 'V', 'P', 'Z', 'J', 'A', 'Y', 'Q', 'U', 'I', 'R', 'H', 'X', 'L', 'N', 'F', 'T', 'G', 'K', 'D', 'C', 'M', 'W', 'B'};
		Character[] walzeFuenf = {'V', 'Z', 'B', 'R', 'G', 'I', 'T', 'Y', 'U', 'P', 'S', 'D', 'N', 'H', 'L', 'X', 'A', 'W', 'M', 'J', 'Q', 'O', 'F', 'E', 'C', 'K'};

		switch (this.walzennr) {
			case 1:
				walze = walzeEins;
				break;
			case 2:
				walze = walzeZwei;
				break;
			case 3:
				walze = walzeDrei;
				break;
			case 4:
				walze = walzeVier;
				break;
			case 5:
				walze = walzeFuenf;
				break;
		}

		return walze;
	}

	/**
	 * TODO: Dokumentieren
	 *
	 * @return ringstellung : Character : gibt die neue Ringstellung zurueck
	 */
	public char getRingstellung() {
		return ringstellung;
	}

	/**
	 * Gibt die Initiale Ringstellung der Walze an.
	 * Es sind nur Zahlen von 1 - 26 zugelassen.
	 * Im Fehlerfall wird die Ringstellung standardmaessig auf '1' gesetzt.
	 *
	 * @param ringstellung : Character : Punkt an dem die Walze umspringt
	 */
	public void setRingstellung(int ringstellung) {
		if (ringstellung > 0 && ringstellung <= 26) {
			this.ringstellung = this.alphabet[ringstellung - 1];
		} else {
			this.ringstellung = 'Z';
		}
	}

	/**
	 * dreheWalze() return boolean => Wenn Notch erreicht, gib true zurück, ansonsten false
	 * TODO: Doku
	 */
	public boolean dreheWalze(int... drehung) {

		boolean checkRing = false;

		verschiebung();

		if (drehung.length > 0) {
			for (int i = 1; i < drehung[0]; i++) {
				verschiebung();
			}
		}

		if (this.getPosition().equals(this.ringstellung)) {
			checkRing = true;
		}

		return checkRing;
	}

	/**
	 * TODO: Dokumentieren
	 */
	private void verschiebung() {

		Character[] neueWalze = new Character[26];

		for (int index = 0; index < neueWalze.length; index++) {
			neueWalze[(index + 1) % neueWalze.length] = this.walzeAlpha[index];
		}
		this.walzeAlpha = neueWalze;
	}

	/**
	 * TODO: Dokumentieren
	 * TODO: Ich glaube das kann weg?
	 *
	 * @return
	 */
	public char getAnzeige() {
		int temp = this.getArrayIndex('A', this.walzeAlpha);

		return this.alphabet[temp];
	}

	/**
	 * Chiffriert den Buchstaben an der Position aus der Methode positionBuchstabe()
	 * anhand der gewaehlten Walze.
	 *
	 * @return chiffrierterBuchstabe : Character : chiffrierter Buchstabe
	 */
	public char codiere(char buchstabe) {
		for (int i = 0; i < walzeAlpha.length; i++) {
			if (walzeAlpha[i].equals(buchstabe)) {
				buchstabe = walzenNummer()[i];
				break;
			}
		}

		return buchstabe;
	}

	/**
	 * Chiffriert den Buchstaben an der Position aus der Methode positionBuchstabeReverse()
	 * anhand der AlphaWalze.
	 *
	 * @return codierterBuchstabeRe : Character : chiffrierter Buchstabe
	 */
	public char codiere2(char buchstabe) {
		for (int i = 0; i < walzenNummer().length; i++) {
			if (walzenNummer()[i].equals(buchstabe)) {
				buchstabe = walzeAlpha[i];
				break;
			}
		}

		return buchstabe;
	}

	/**
	 * TODO: Dokumentieren
	 *
	 * @param buchstabe : Character
	 * @param array : Character[]
	 * @return int
	 */
	private int getArrayIndex(Character buchstabe, Character[] array) {

		int result = -1;

		for (int i = 0; i < array.length; i++) {
			if (array[i].equals(buchstabe)) {
				result = i;
				break;
			}
		}

		return result;
	}

	/**
	 * Definiert die Walze. Es stehen fuenf Walze zur Auswahl.
	 *
	 * @param walzennr : int : setzt die Walzennummer
	 */
	public void setWalzennr(int walzennr) {
		if (walzennr > 0 && walzennr < 6) {
			this.walzennr = walzennr;
		} else {
			System.err.println("Keine gültige Walzennummer");
		}
	}

	/**
	 * TODO: Dokumentieren
	 *
	 * @return Character
	 */
	public Character getPosition() {
		return walzeAlpha[0];
	}

	/**
	 * Gibt die Grundeinstellung der Walze ein. Nur Buchstaben von A - Z sind zugelassen.
	 * Buchstaben werden automatisch in Grossbuchstaben umgewandelt.
	 * Im Fehlerfall wird die Grundeinstellung der Walze standardmaessig auf 'A' gesetzt.
	 * TODO: Funktionsname hat sich geändert
	 *
	 * @param buchstabe : Character : Grundeinstellung der Walze
	 */
	public void setPosition(Character buchstabe) {
		if (Character.isLetter(buchstabe)) {
			buchstabe = Character.toUpperCase(buchstabe);
			System.arraycopy(this.alphabet, 0, this.walzeAlpha, 0, this.alphabet.length);
			if (buchstabe > 'A') {
				dreheWalze(this.getArrayIndex(buchstabe, this.alphabet));
			}
		}
	}
}
