package projekt.enigma.model;

/**
 * Klasse Steckbrett
 * <br>
 * Das Steckbrett diente dazu Buchstaben paarweise zu vertauschen noch bevor diese durch die Walzen codiert werden.
 * Die Klasse Steckbrett nimmt bis zu 10 paarweise zu vertauschende Buchstabenpaare entgegen, prueft diese auf
 * Zulaessigkeit und tauscht diese dann paarweise aus.
 */
public class Steckbrett {

    /**
     * zaehler: Int, der als Laufvariable genutzt wird
     */
    private int zaehler;

    /**
     * orginalBuchstaben: Character-Array, der jeweils den ersten zu vertauschenden Buchstaben enthält
     */
    private Character[] orginalBuchstaben;

    /**
     * getauschteBuchstaben: Character-Array, der jeweils den zweiten zu vertauschenden Buchstaben enthält
     */
    private Character[] getauschteBuchstaben;


    /**
     * Konstruktor Steckbrett
     * <br>
     * Erzeugt zwei Charakter-Arrays (orginalBuchstaben und getauschteBuchstaben) der Länge 10.
     */
    public Steckbrett() {

        orginalBuchstaben = new Character[10];
        getauschteBuchstaben = new Character[10];
    }

    /**
     * TODO: Fehlerfall kommentieren, bzw. Exceptions werfen ?????
     * TODO: Überprüfe Vertauschungen für jeden Buchstaben aufrufen
     * Funktion setzeVertauschung
     * <br>
     * Der Funktion setzeVertauschung werden 2 Buchstaben (buchstabe1 und buchstabe2) übergeben.
     * buchstabe1 wird in das Character-Array orginalBuchstaben geschrieben.
     * buchstabe2 wird in das Character-Array getauschteBuchstaben geschrieben.
     * Anschließend wird die Funktion ueberpruefeVertauschungen aufgerufen.
     *
     * @param buchstabe1 : char: Gibt den ersten Buchstaben an, der getauscht werden soll.
     * @param buchstabe2 : char: gibt den zweiten Buchstaben an, mit dem der erste getauscht werden soll.
     * @return ueberpruefeVertauschungen(): Ueberprueft ob die Vertauschungen zulaessig sind.
     */
    public boolean setzeVertauschung(char buchstabe1, char buchstabe2) {
        if (zaehler < orginalBuchstaben.length) {
            orginalBuchstaben[zaehler] = buchstabe1;
            getauschteBuchstaben[zaehler++] = buchstabe2;
        } else {
            System.err.println("Zu viele Vertauschungen angegeben!");
        }

        return ueberpruefeVertauschungen();
    }

    /**
     * TODO: Fehlerfall kommentieren, bzw. Exceptions werfen ?????
     * TODO: Buchstabe zum überpüfen übergeben
     * Funktion ueberpruefeVertauschungen
     * <br>
     * Die Funktion ueberpruefeVertauschungen prueft ob die Buchstabenvertauschung zulaessig ist.
     * Eine Buchstabenvertauschung ist zulaessig, wenn keine Dopplungen der zu vertauschenden Buchstaben auftritt
     * (ein Buchstabe nicht mehrmals vertauscht wird).
     *
     * @return boolean : result : Flag, der die Zulassigkeit der Vertauschungen zurueckgibt.
     */
    public boolean ueberpruefeVertauschungen() {
        boolean result = true;

        /*Es wird geprüft:
        1. Ob im Array originalBuchstaben Dopplungen enthalten sind.
        2. Ob im Array originalBuchstaben Buchstaben im Array getauschteBuchstaben enthalten sind.
        3. Ob im Array getauschteBuchstaben Dopplungen enthalten sind.
        Tritt einer der Fälle ein, erfolgt eine Konsolenausgabe und der Flag wird auf false gesetzt.
         */
        for (int n = 0; n < orginalBuchstaben.length; n++) {
            if (orginalBuchstaben.equals(orginalBuchstaben[n]) ||
                    getauschteBuchstaben.equals(orginalBuchstaben[n]) ||
                    getauschteBuchstaben.equals(getauschteBuchstaben[n])) {
                System.err.println("Vertauschungen enthalten unzulässige Dopplungen");
                result = false;
            }
        }

        return result;
    }

    /**
     * Funktion codiere
     * <br>
     * Die Funktion codiere tauscht den uebergebenen Character buchstabe mit dem zu tauschenden Character aus.
     *
     * @param buchstabe : Character : Buchstabe der codiert werden soll.
     * @return buchstabe : Character : Codierter Buchstabe.
     */
    public char codiere(Character buchstabe) {
        for (int index = 0; index < getauschteBuchstaben.length; index++) {
            if (buchstabe.equals(getauschteBuchstaben[index])) {
                buchstabe = orginalBuchstaben[index];
            } else if (buchstabe.equals(orginalBuchstaben[index])) {
                buchstabe = getauschteBuchstaben[index];
            }
        }

        return buchstabe;
    }

}
