package projekt.enigma;

import projekt.enigma.model.Codierer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.*;
import javafx.scene.shape.Circle;
import org.apache.http.HttpException;

import java.io.IOException;
import java.util.ArrayList;

public class GuiController {

	private final static String[] walzenNr = {"I", "II", "III", "IV", "V"};
	private final static String[] ringNr = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
	private final static String[] position = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
	private ArrayList<MenuItem> mItem;
	private String textEingabe;
	private String textCodiert;
	private boolean resetDisplay;
	private Codierer codierer;

	@FXML
	private Button btnL;

	@FXML
	private Button btnP;

	@FXML
	private Button btnY;

	@FXML
	private Button btnX;

	@FXML
	private Button btnC;

	@FXML
	private Button btnV;

	@FXML
	private Button btnB;

	@FXML
	private Button btnN;

	@FXML
	private Button btnM;

	@FXML
	private Button btnA;

	@FXML
	private Button btnS;

	@FXML
	private Button btnD;

	@FXML
	private Button btnF;

	@FXML
	private Button btnG;

	@FXML
	private Button btnH;

	@FXML
	private Button btnJ;

	@FXML
	private Button btnK;

	@FXML
	private Button btnQ;

	@FXML
	private Button btnW;

	@FXML
	private Button btnE;

	@FXML
	private Button btnR;

	@FXML
	private Button btnT;

	@FXML
	private Button btnZ;

	@FXML
	private Button btnU;

	@FXML
	private Button btnI;

	@FXML
	private Button btnO;

	@FXML
	private MenuButton mBtnWalzPos1;

	@FXML
	private MenuButton mBtnWalzPos3;

	@FXML
	private MenuButton mBtnWalzPos2;

	@FXML
	private MenuButton mBtnNotchPos3;

	@FXML
	private MenuButton mBtnNotchPos2;

	@FXML
	private MenuButton mBtnStartPos1;

	@FXML
	private MenuButton mBtnStartPos3;

	@FXML
	private MenuButton mBtnStartPos2;

	@FXML
	private TextField tfKlartext;

	@FXML
	private TextField tfCodiert;

	@FXML
	private MenuButton mBtnNotchPos1;

	@FXML
	private TextField tfStecker1;

	@FXML
	private TextField tfStecker2;

	@FXML
	private TextField tfStecker3;

	@FXML
	private TextField tfStecker4;

	@FXML
	private TextField tfStecker5;

	@FXML
	private TextField tfStecker6;

	@FXML
	private TextField tfStecker7;

	@FXML
	private TextField tfStecker8;

	@FXML
	private TextField tfStecker9;

	@FXML
	private TextField tfStecker10;

	@FXML
	private Label lblQ;

	@FXML
	private Label lblE;

	@FXML
	private Label lblW;

	@FXML
	private Label lblR;

	@FXML
	private Label lblT;

	@FXML
	private Label lblZ;

	@FXML
	private Label lblO;

	@FXML
	private Label lblI;

	@FXML
	private Label lblU;

	@FXML
	private Label lblA;

	@FXML
	private Label lblD;

	@FXML
	private Label lblS;

	@FXML
	private Label lblF;

	@FXML
	private Label lblG;

	@FXML
	private Label lblH;

	@FXML
	private Label lblK;

	@FXML
	private Label lblJ;

	@FXML
	private Label lblP;

	@FXML
	private Label lblX;

	@FXML
	private Label lblY;

	@FXML
	private Label lblC;

	@FXML
	private Label lblV;

	@FXML
	private Label lblB;

	@FXML
	private Label lblL;

	@FXML
	private Label lblM;

	@FXML
	private Label lblN;

	@FXML
	private Circle circE;

	@FXML
	private Circle circR;

	@FXML
	private Circle circT;

	@FXML
	private Circle circZ;

	@FXML
	private Circle circU;

	@FXML
	private Circle circI;

	@FXML
	private Circle circO;

	@FXML
	private Circle circA;

	@FXML
	private Circle circS;

	@FXML
	private Circle circD;

	@FXML
	private Circle circF;

	@FXML
	private Circle circG;

	@FXML
	private Circle circH;

	@FXML
	private Circle circJ;

	@FXML
	private Circle circK;

	@FXML
	private Circle circP;

	@FXML
	private Circle circY;

	@FXML
	private Circle circX;

	@FXML
	private Circle circC;

	@FXML
	private Circle circV;

	@FXML
	private Circle circB;

	@FXML
	private Circle circN;

	@FXML
	private Circle circM;

	@FXML
	private Circle circL;

	@FXML
	private Circle circW;

	@FXML
	private Circle circQ;

	@FXML
	void initialize() {

		// Variablen setzen
		textEingabe = "";
		textCodiert = "";
		resetDisplay = true;

		//Einträge für Walzen
		menu(mBtnWalzPos1, walzenNr);
		menu(mBtnWalzPos2, walzenNr);
		menu(mBtnWalzPos3, walzenNr);

		//Einträge für die Ringe
		menu(mBtnNotchPos1, ringNr);
		menu(mBtnNotchPos2, ringNr);
		menu(mBtnNotchPos3, ringNr);

		//Einträge für die Startpositionen
		menu(mBtnStartPos1, position);
		menu(mBtnStartPos3, position);
		menu(mBtnStartPos2, position);


		//Setze Leucht Event bei Tastendruck
		leuchten(btnA, circA);
		leuchten(btnB, circB);
		leuchten(btnC, circC);
		leuchten(btnD, circD);
		leuchten(btnE, circE);
		leuchten(btnF, circF);
		leuchten(btnG, circG);
		leuchten(btnH, circH);
		leuchten(btnI, circI);
		leuchten(btnJ, circJ);
		leuchten(btnK, circK);
		leuchten(btnL, circL);
		leuchten(btnM, circM);
		leuchten(btnN, circN);
		leuchten(btnO, circO);
		leuchten(btnP, circP);
		leuchten(btnQ, circQ);
		leuchten(btnR, circR);
		leuchten(btnS, circS);
		leuchten(btnT, circT);
		leuchten(btnU, circU);
		leuchten(btnV, circV);
		leuchten(btnW, circW);
		leuchten(btnX, circX);
		leuchten(btnY, circY);
		leuchten(btnZ, circZ);

		this.codierer = new Codierer();
		this.codierer.setKenngruppe("enigma");

		// Walzen auf ihre Position setzen. Der Spruchschlüssel ist hier bereits berücksichtigt.
		mBtnStartPos1.setText(String.valueOf(this.codierer.getWalzen()[0]));
		mBtnStartPos2.setText(String.valueOf(this.codierer.getWalzen()[1]));
		mBtnStartPos3.setText(String.valueOf(this.codierer.getWalzen()[2]));
	}

	@FXML
	private void loeschen() {
		if (textEingabe.length()==0){
			tfKlartext.setText("");
		}else {
			textEingabe = textEingabe.substring(0, textEingabe.length() - 1);
			tfKlartext.setText(textEingabe);
		}
	}

	@FXML
	void btnempfangen() {
		String[] empfangeneNachricht = this.codierer.empfangeNachricht();
		if (empfangeneNachricht[0] != null) {
			this.tfKlartext.setText(empfangeneNachricht[2]);
			this.tfCodiert.setText(empfangeneNachricht[1]);
			this.resetDisplay = true;

			mBtnStartPos1.setText(String.valueOf(this.codierer.getWalzen()[0]));
			mBtnStartPos2.setText(String.valueOf(this.codierer.getWalzen()[1]));
			mBtnStartPos3.setText(String.valueOf(this.codierer.getWalzen()[2]));
		}
	}

	@FXML
	void btnsenden() {
		this.tfKlartext.setText("");
		this.tfCodiert.setText("");

		try {
			this.codierer.sendeNachricht();
		} catch (HttpException | IOException e) {
			e.printStackTrace();
		}

	}

	/**
	 * Methode zum setzen des menuButton Textes auf das ausgewählte MenuItem
	 *
	 * @param mb : MenuButton der Walze
	 * @param mi : MenuItem
	 */
	private void listener(MenuButton mb, MenuItem mi) {
		// mb.setText(mi.getText());

		if(mb.getId().equals(mBtnStartPos1.getId()))setzePosition(1,mi.getText().charAt(0));
		if(mb.getId().equals(mBtnStartPos2.getId()))setzePosition(2,mi.getText().charAt(0));
		if(mb.getId().equals(mBtnStartPos3.getId()))setzePosition(3,mi.getText().charAt(0));
		if(mb.getId().equals(mBtnWalzPos1.getId()))setzeWalze(1,mi.getText());
		if(mb.getId().equals(mBtnWalzPos2.getId()))setzeWalze(2,mi.getText());
		if(mb.getId().equals(mBtnWalzPos3.getId()))setzeWalze(3,mi.getText());
		if(mb.getId().equals(mBtnNotchPos1.getId()))
			setzeRing(1,Integer.parseInt(mi.getText())-1);
		if(mb.getId().equals(mBtnNotchPos2.getId()))
			setzeRing(2,Integer.parseInt(mi.getText())-1);
		if(mb.getId().equals(mBtnNotchPos3.getId()))
			setzeRing(3,Integer.parseInt(mi.getText())-1);
	}

	/**
	 * Methode zur Erstellung der Einträge und Action Listener für die einzelnen Menüs
	 *
	 * @param button : Button für die die Einträge erstellt werden sollen
	 */
	private void menu(MenuButton button, String[] str) {
		mItem = new ArrayList<>();
		for (int i = 0; i < str.length; i++) {
			//Eintrag aus str der Arraylist mi hinzufügen
			mItem.add(new MenuItem(str[i]));
			//MenuItem mi dem Button button hinzufügen
			button.getItems().add(mItem.get(i));
			int finalI = i;
			//Listener für die einzelnen Einträge
			ArrayList<MenuItem> finalMi = mItem;
			mItem.get(i).setOnAction(e -> listener(button, finalMi.get(finalI)));
		}
	}

	/**
	 * Auswertung welcher Button gedrückt wurde
	 *
	 * @param e => ActionEvent des auslösenden Button
	 */
	@FXML
	private void gedrueckteTaste(ActionEvent e) {

		//TODO Anbindung an Klasse Hardware
		if (e.getSource() == btnA) setText(btnA);
		if (e.getSource() == btnB) setText(btnB);
		if (e.getSource() == btnC) setText(btnC);
		if (e.getSource() == btnD) setText(btnD);
		if (e.getSource() == btnE) setText(btnE);
		if (e.getSource() == btnF) setText(btnF);
		if (e.getSource() == btnG) setText(btnG);
		if (e.getSource() == btnH) setText(btnH);
		if (e.getSource() == btnI) setText(btnI);
		if (e.getSource() == btnJ) setText(btnJ);
		if (e.getSource() == btnK) setText(btnK);
		if (e.getSource() == btnL) setText(btnL);
		if (e.getSource() == btnM) setText(btnM);
		if (e.getSource() == btnN) setText(btnN);
		if (e.getSource() == btnO) setText(btnO);
		if (e.getSource() == btnP) setText(btnP);
		if (e.getSource() == btnQ) setText(btnQ);
		if (e.getSource() == btnR) setText(btnR);
		if (e.getSource() == btnS) setText(btnS);
		if (e.getSource() == btnT) setText(btnT);
		if (e.getSource() == btnU) setText(btnU);
		if (e.getSource() == btnV) setText(btnV);
		if (e.getSource() == btnW) setText(btnW);
		if (e.getSource() == btnX) setText(btnX);
		if (e.getSource() == btnY) setText(btnY);
		if (e.getSource() == btnZ) setText(btnZ);
	}

	/**
	 * schreibt Buchstaben des gedrückten Knopfes in Textfeld tfrein
	 *
	 * @param b : gedrückter Knopf
	 */
	private void setText(Button b) {
		if (textEingabe.length() < 250) {
			if(this.resetDisplay) {
				this.tfCodiert.setText("");
				this.tfKlartext.setText("");
				this.resetDisplay = false;
				this.codierer.resetHardware();
				textCodiert = "";
				textEingabe = "";
				// Spruchschlüssel generieren und codieren
				this.codierer.generateSpruchschluessel();
			}
			textEingabe += b.getText();
			textCodiert += this.codierer.codiere(b.getText().charAt(0), true);

			tfKlartext.setText(textEingabe);
			tfCodiert.setText(textCodiert);

			mBtnStartPos1.setText(String.valueOf(this.codierer.getWalzen()[0]));
			mBtnStartPos2.setText(String.valueOf(this.codierer.getWalzen()[1]));
			mBtnStartPos3.setText(String.valueOf(this.codierer.getWalzen()[2]));
		}
	}

	private void leuchten(Button taste, Circle leuchte) {

		taste.setOnMousePressed(mouseEvent -> leuchte.setStyle("-fx-fill: #FFA500"));
		taste.setOnMouseReleased(mouseEvent -> {
			leuchte.setStyle("-fx-background-color: " + taste.getBackground());
			leuchte.setStyle("-fx-border-color:  #000000");
		});
	}

	/**
	 * Setzt die Anzeige des entsprechende Gui-Element auf die entsprechende Walze
	 * ->d.h. welche Walze sitzt auf welcher Position
	 *
	 * @param walzeRoemischNr    => gibt die Walzennummer an
	 * @param walzenPosition => gibt die Position der Walze
	 */
	private void setzeWalze(int walzenPosition, String walzeRoemischNr) {
		int walzeNr=0;
		switch (walzeRoemischNr){
			case "I":
				walzeNr=0;
				break;
			case "II":
				walzeNr=1;
				break;
			case "III":
				walzeNr=2;
				break;
			case "IV":
				walzeNr=4;
				break;
			case "V":
				walzeNr=4;
				break;
			default:
				break;
		}

		switch (walzenPosition) {
			case 1:
				mBtnWalzPos1.setText(walzenNr[walzeNr]);
				//codierer.setWalze(walzeNr, walzenPosition)
				break;
			case 2:
				mBtnWalzPos2.setText(walzenNr[walzeNr]);

				break;
			case 3:
				mBtnWalzPos3.setText(walzenNr[walzeNr]);
				break;
			default:
				break;
		}
	}

	/**
	 * Setzt den Notch (position)=> die Mitnahmeposition der Walze (walze) fest
	 * Mitnahmeposition meint => die nächste Walze wird bei erreichen dieser Position (notch)
	 * um eine Stelle versetzt
	 *
	 * @param ringStellung    => gibt die walze an
	 * @param walzenPosition => gibt den notch der Walze (walze) an
	 */
	private void setzeRing(int walzenPosition, int ringStellung) {
		switch (walzenPosition) {
			case 1:
				mBtnNotchPos1.setText(ringNr[ringStellung]);
				break;
			case 2:
				mBtnNotchPos2.setText(ringNr[ringStellung]);
				break;
			case 3:
				mBtnNotchPos3.setText(ringNr[ringStellung]);
				break;
			default:
				break;
		}
	}

	/**
	 * Setzt die Startposition/ aktuelle Position der Walze
	 *
	 * @param walze     => gibt die walze an
	 * @param buchstabe gibt den Startwert bzw die aktuelle Position der Walze (walze) an
	 */
	private void setzePosition(int walze, char buchstabe) {
		switch (walze) {
			case 1:
				mBtnStartPos1.setText(String.valueOf(buchstabe));
				break;
			case 2:
				mBtnStartPos2.setText(buchstabe + "");
				break;
			case 3:
				mBtnStartPos3.setText(buchstabe + "");
				break;
			default:
				break;
		}
	}

	/**
	 * Setzt den aktuellen TagesSchluessel
	 *
	 * @param tagesSchluessel => neuen Tagesschluessel übergeben
	 */
	public void setzeTagesSchluessel(String tagesSchluessel) {
		/*
		 * TODO Benötige TestString aus der DB Codebuch
		 *
		 * Den Tagesschlüssel bekommst du wie folgt:
		 * <p>
		 *     // Aktuelle Position der Walzen
		 *     codierer.codebuch.getWalzenlage();
		 *
		 *     // Position der Ringe
		 *     codierer.codebuch.getRingstellung();
		 *
		 *     //Position der Steckverbindungen
		 *     codierer.codebuch.getSteckverbindung();
		 * </p>
		 */

	}
}
