package projekt.enigma.model;

/**
 * Klasse Walze
 * <br>
 * Erzeugt ein Objekt des Typs Walze mit den Eigenschaften:
 * <br>
 * 1. Walzennummer (Die Walze enthält die 26 Buchstaben des Alphabeths und codiert diese.
 * 5 verschiedene Walzen stehen zur Auswahl, die jeweils verschieden die Buchstaben des Alphabeths
 * paarweise vertauschen)
 * <br>
 * 2. Ringstellung (Umspringpunkt der Walze wird festgelegt. Der Umspringpunkt bestimmt
 * den Drehzeitpunkt der linken Nachbarwalze)
 */
public class Walze {

    /**
     * walzeAlpha : Character[] : Array, dass die Buchstaben des Alphabets enthaelt
     */
    private Character[] alphabet;

	/**
	 * ringstellung : char : zeigt die Einstellung fuer den Umspringpunkt
	 */
	private char ringstellung;

	/**
	 *  walzennr : int : Bestimmt, welche Walze genutzt wird
	 */
    private int walzennr;

	/**
	 *  alphabet : Character[] : Enthaelt die Buchstaben des Alphabets. Wird im Laufe des Programmes
	 *  aber immer wieder ueberschrieben.
	 */
    private Character[] walzeAlpha;

    /**
     * Ueberschriebener Konstruktor, der die Eingangsparameter der Walze mitgibt
     *
     * @param walzennr     : int : Nummer der gewaehlten Walze
     * @param ringstellung : int : Einstellung des Umsprungpunktes
     */
    public Walze(int walzennr, int ringstellung) {
        this.alphabet = new Character[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
                                        'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        this.walzeAlpha = new Character[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
                                          'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

        this.setWalzennr(walzennr);
        this.setRingstellung(ringstellung);
    }

    /**
     * Sortiert der Walzennummer das passende Character-Array mittels switch zu.
     *
     * @return walze : Character[] : gibt die gewaehlte Walze zurueck
     */
    private Character[] walzenNummer() {
        Character[] walze = new Character[26];

        // Character-Arrays fuer die Codierung jeder Walze
        Character[] walzeEins = {'E', 'K', 'M', 'F', 'L', 'G', 'D', 'Q', 'V', 'Z', 'N', 'T', 'O', 'W', 'Y',
                                 'H', 'X', 'U', 'S', 'P', 'A', 'I', 'B', 'R', 'C', 'J'};
        Character[] walzeZwei = {'A', 'J', 'D', 'K', 'S', 'I', 'R', 'U', 'X', 'B', 'L', 'H', 'W', 'T', 'M',
                                 'C', 'Q', 'G', 'Z', 'N', 'P', 'Y', 'F', 'V', 'O', 'E'};
        Character[] walzeDrei = {'B', 'D', 'F', 'H', 'J', 'L', 'C', 'P', 'R', 'T', 'X', 'V', 'Z', 'N', 'Y',
                                 'E', 'I', 'W', 'G', 'A', 'K', 'M', 'U', 'S', 'Q', 'O'};
        Character[] walzeVier = {'E', 'S', 'O', 'V', 'P', 'Z', 'J', 'A', 'Y', 'Q', 'U', 'I', 'R', 'H', 'X',
                                 'L', 'N', 'F', 'T', 'G', 'K', 'D', 'C', 'M', 'W', 'B'};
        Character[] walzeFuenf = {'V', 'Z', 'B', 'R', 'G', 'I', 'T', 'Y', 'U', 'P', 'S', 'D', 'N', 'H', 'L',
                                  'X', 'A', 'W', 'M', 'J', 'Q', 'O', 'F', 'E', 'C', 'K'};

        switch (this.walzennr) {
            case 1:
                walze = walzeEins;
                break;
            case 2:
                walze = walzeZwei;
                break;
            case 3:
                walze = walzeDrei;
                break;
            case 4:
                walze = walzeVier;
                break;
            case 5:
                walze = walzeFuenf;
                break;
        }

        return walze;
    }

    /**
     * TODO: Dokumentieren
     *
     * @return ringstellung : char : gibt die neue Ringstellung als char zurueck
     */
    public char getRingstellung() {
        return ringstellung;
    }

    /**
     * Setzt die Initiale Ringstellung der Walze.
     * Es sind nur Zahlen von 1 - 26 zugelassen.
	 *
	 * Die Ringstellung wird zum char umgewandelt.
     * Im Fehlerfall wird die Ringstellung standardmaessig auf 'Z' gesetzt.
     *
     * @param ringstellung : int : Punkt an dem die Walze umspringt
     */
    //TODO ??? Setter Ringstellung
    public void setRingstellung(int ringstellung) {
        if ((ringstellung > 0) && (ringstellung <= 26)) {
            this.ringstellung = this.alphabet[ringstellung - 1];
        } else {
            this.ringstellung = 'Z';
        }
    }

    /**
     * Dreht die Walze: verschiebt das Alphabet um keine, eine oder mehrere Stellen und ueberschreibt
	 * das Array alphabet mit der neuen Anordnung.
	 *
	 * Ueberprueft, ob der Umspringpunkt der Walze nach der Drehung erreicht wurde.
	 *
	 * @param drehung : int[] : Anzahl der Drehungen
	 * @return checkRing : boolean : gibt true zurueck wenn der Umspringpunkt erreicht wurde
     * TODO: Doku
     */
    public boolean dreheWalze(int... drehung) {
        boolean checkRing = false;

        // fuehrt die Verschiebung des Alphabets um eine Stelle durch
        verschiebung();

        // fuehrt die Verschiebung mehrfach aus, wenn mehrere Drehungen ausgefuehrt werden sollen
        if (drehung.length > 0) {
            for (int i = 1; i < drehung[0]; i++) {
                verschiebung();
            }
        }

        // gleicht die Ringstellung mit der aktuellen Position ab
        if (this.getPosition().equals(this.ringstellung)) {
            checkRing = true;
        }

        return checkRing;
    }

    /**
	 * Ueberschreibt die Alphabetswalze mit dem, durch die Drehung, verschobenen Alphabet.
     * TODO: Dokumentieren
     */
    private void verschiebung() {
        Character[] neueWalze = new Character[26];

        for (int index = 0; index < neueWalze.length; index++) {
            neueWalze[(index + 1) % neueWalze.length] = this.walzeAlpha[index];
        }

        this.walzeAlpha = neueWalze;
    }

    /**
     * TODO: Dokumentieren // dass selbe wie getPosition
     * Gibt den Buchstaben zurueck der in der Walze aktuell eingestellt ist.
	 *
     * @return char an der Stelle temp des Alphabets
     */
    public char getAnzeige() {
        int temp = this.fetchArrayIndex('A', this.walzeAlpha);
        return this.alphabet[temp];
    }

    /**
     * Codiert den mitgegebenen Buchstaben anhand der gewaehlten Walze.
     *
	 * @param buchstabe : char : Buchstabe, der verschluesselt werden soll
     * @return buchstabe : char : verschluesselter Buchstabe
     */
    public char codiere(char buchstabe) {
        /* durchsucht die (verschobene) Alphabetswalze nach dem aktuellen Buchstaben und
        uebertraegt den Index auf die gewaehlte Codierwalze*/
        buchstabe = walzenNummer()[fetchArrayIndex(buchstabe, walzeAlpha)];

        return buchstabe;
    }

    /**
     * Decodiert den mitgegebenen Buchstaben mit Hilfe der (verschobenen) Alphabetswalze
     *
	 * @param buchstabe : char : Buchstabe, der decodiert werden soll
     * @return buchstabe : char : decodierter Buchstabe
     */
    public char codiere2(char buchstabe) {
        /* durchsucht die gewaehlte Walze nach dem aktuellen Buchstaben und
        uebertraegt den Index auf die (verschobene) Alphabetswalze*/
		buchstabe = walzeAlpha[fetchArrayIndex(buchstabe, walzenNummer())];

        return buchstabe;
    }

    /**
     * TODO: Dokumentieren
     * Ermittelt den Index eines Characters in einem Array ueber eine for-Schleife
	 *
     * @param buchstabe : Character : Buchstabe, dessen Index benoetigt wird
     * @param array : Character[] : Array, in dem der Buchstabe vorkommen soll
     * @return result : int : index des Buchstaben
     */
    private int fetchArrayIndex(Character buchstabe, Character[] array) {
        // wird mit ungueltigem Wert initialisiert
    	int result = -1;

        for (int i = 0; i < array.length; i++) {
            if (array[i].equals(buchstabe)) {
                result = i;
                break;
            }
        }

        return result;
    }

    /**
     * Setzt die Walzennummer. Es stehen fuenf Walze zur Auswahl.
     *
     * @param walzennr : int : Walzennummer
     */
    public void setWalzennr(int walzennr) {
        if ((walzennr > 0) && (walzennr < 6)) {
            this.walzennr = walzennr;
        } else {
            System.err.println("Keine gültige Walzennummer");
        }
    }

    /**
     * TODO: Dokumentieren // das selbe wie getAnzeig?
	 * Gibt den Character zurueck, der aktuell in der Walze eingestellt ist
     *
     * @return Character am Index 0 des (verschobenen) Alphabets zurueck
     */
    public Character getPosition() {
        return walzeAlpha[0];
    }

    /**
     * 	 * TODO: Funktionsname hat sich geändert
     * Gibt die Grundeinstellung der Walze ein. Nur Buchstaben von A - Z sind zugelassen.
     * Buchstaben werden automatisch in Grossbuchstaben umgewandelt.
     * Ist die Grundeinstellung nicht 'A', wird die Methode dreheWalze() aufgerufen.
     *
     * @param buchstabe : Character : Einstellung der Walze
     */
    public void setPosition(Character buchstabe) {
        if (Character.isLetter(buchstabe)) {
            buchstabe = Character.toUpperCase(buchstabe);
            System.arraycopy(this.alphabet, 0, this.walzeAlpha, 0, this.alphabet.length);
            if (buchstabe > 'A') {
                dreheWalze(this.fetchArrayIndex(buchstabe, this.walzeAlpha));
            }
        }
    }
}
