package projekt.enigma.model;

/**
 * Klasse Reflektor
 * <br>
 * Der Reflektor nimmt einen Buchstaben der Klasse Walze entgegen und und kodiert diesen.
 * Der kodierte Buchstabe wird an die Klasse Walze wieder zurückgegeben.
 * <br>
 * Prinzipiell verhält sich die Klasse Reflektor wie die Klasse Walze, außer das sie sich
 * nach Betätigung einer Taste nicht dreht (quasi starr montiert ist) und sie gibt keine Signale
 * an andere Walzen zum drehen.
 */
public class Reflektor {

    /**
     * WALZE_ALPHABET : konstanter Char-Array mit den Werten des Alphabeths (26 Werte)
     */
    private final Character[] WALZE_ALPHABET = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    /**
     * WALZE_REFLEKTOR : konstanter Char-Array mit den Werten des Reflektors (26 Werte)
     */
    private final Character[] WALZE_REFLEKTOR = {'E', 'J', 'M', 'Z', 'A', 'L', 'Y', 'X', 'V', 'B', 'W', 'F', 'C', 'R', 'Q', 'U', 'O', 'N', 'T', 'S', 'P', 'I', 'K', 'H', 'G', 'D'};


    /**
     * Funktion codiere
     * <br>
     * Durchsucht das konstante Char-Array WALZE_ALPHABET nach der Position eines bestimmten
     * Buchstabens und gibt den Character an der entsprechenden Position im konstanten
     * Char-Array WALZE_REFLEKTOR zurück.
     *
     * @return WALZE_REFLEKTOR[iPositionReflektor]: Character: Der kodierte Buchstabe aus dem Reflektor
     */
    public char codiere(Character buchstabe) {
        int iPositionReflektor = 0;

        //Ermittelt die Position des Buchstaben "buchstabe" auf der Alphabetswalze
        for (int index = 0; index < WALZE_ALPHABET.length; index++) {
            if (buchstabe.equals(WALZE_ALPHABET[index])) {
                iPositionReflektor = index;
                break;
            }
        }

        return WALZE_REFLEKTOR[iPositionReflektor];
    }
}
