package projekt.enigma.model;

/**
 * TODO: Dokumentation aktuallisieren
 * <p>
 * Klasse Walze
 * <br>
 * Erzeugt ein Objekt des Typs Walze mit den Eigenschaften:
 * <br>
 * 1. Walzennummer (Die Walze enthält die 26 Buchstaben des Alphabeths und codiert diese.
 * 5 verschiedene Walzen stehen zur Auswahl, die jeweils verschieden die Buchstaben des Alphabeths
 * paarweise vertauschen)
 * <br>
 * 2. Ringstellung (Umspringpunkt der Walze wird festgelegt. Der Umspringpunkt bestimmt
 * den Drehzeitpunkt der linken Nachbarwalze)
 */
public class Walze {

	//region Variablen
	/**
	 * Die Anzahl der getätigten Walzen Drehungen
	 * TODO: Wieder auf private setzen
	 */
	public int turns;
	/**
	 * Das String Array aller bekannter aktuellen Walzen
	 */
	private String[] walzen;
	/**
	 * alphabet : String dass die Buchstaben des Alphabets enthaelt
	 */
	private String alphabet;
	/**
	 * ringstellung : char : zeigt die Einstellung fuer den Umspringpunkt
	 */
	private char ringstellung;
	/**
	 * walzennr : int : Bestimmt, welche Walze genutzt wird
	 */
	private int walzenNr;
	//endregion

	//region Konstruktor
	/**
	 * Ueberschriebener Konstruktor, der die Eingangsparameter der Walze mit gibt
	 *
	 * @param walzenNr     : int : Nummer der gewaehlten Walze
	 * @param ringstellung : int : Einstellung des Umsprungpunktes
	 */
	public Walze(int walzenNr, int ringstellung) {

		this.walzen = new String[5];
		this.walzen[0] = "EKMFLGDQVZNTOWYHXUSPAIBRCJ";
		this.walzen[1] = "AJDKSIRUXBLHWTMCQGZNPYFVOE";
		this.walzen[2] = "BDFHJLCPRTXVZNYEIWGAKMUSQO";
		this.walzen[3] = "ESOVPZJAYQUIRHXLNFTGKDCMWB";
		this.walzen[4] = "VZBRGITYUPSDNHLXAWMJQOFECK";
		this.alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		this.turns = 0;

		this.setWalzenNr(walzenNr);
		this.setRingstellung(ringstellung);
	}
	//endregion

	//region Funktionen & Methoden
	/**
	 * Dreht die Walze: Zählt die Umdrehungen (Turns) um eines hoch oder runter, je nach Drehrichtung.
	 * <p>
	 * Ueberprueft, ob der Umspringpunkt der Walze nach der Drehung erreicht wurde.
	 *
	 * @param richtung : int : 1 dreht die Walze weiter und -1 dreht sie einen Schritt zurück
	 * @return checkRing : boolean : gibt true zurueck wenn der Umspringpunkt erreicht wurde
	 * TODO: Doku
	 */
	public boolean dreheWalze(int richtung) {

		boolean checkRing = false;
		int korrektorFaktor = 0;

		if (richtung == -1 || richtung == 1) {
			if (richtung == 1) {
				this.turns++;
			} else if (richtung == -1) {
				korrektorFaktor = 1;
				this.turns--;
			}

			// gleicht die Ringstellung mit der aktuellen Position ab
			if ((this.alphabet.indexOf(this.getPosition()) + korrektorFaktor) % 26 == this.alphabet.indexOf(this.ringstellung)) {
				checkRing = true;
			}
		}

		return checkRing;
	}

	/**
	 * Codiert den mitgegebenen Buchstaben anhand der gewaehlten Walze.
	 *
	 * @param buchstabe : char : Buchstabe, der verschluesselt werden soll
	 * @return buchstabe : char : verschluesselter Buchstabe
	 */
	public char codiere(char buchstabe) {
		return this.fetchWalze().charAt((this.alphabet.indexOf(buchstabe) + this.turns) % 26);
	}

	/**
	 * Decodiert den mitgegebenen Buchstaben mit Hilfe der (verschobenen) Walze
	 *
	 * @param buchstabe : char : Buchstabe, der decodiert werden soll
	 * @return buchstabe : char : decodierter Buchstabe
	 */
	public char codiere2(char buchstabe) {
		return this.alphabet.charAt((this.fetchWalze().indexOf(buchstabe) - this.turns + 260) % 26);
	}

	/**
	 * Holt den korrekten String zu der Walze
	 *
	 * @return walze : Character[] : gibt die gewaehlte Walze zurueck
	 */
	private String fetchWalze() {

		return walzen[walzenNr];
	}
	//endregion

	//region Setter
	/**
	 * Setzt die Walzennummer. Es stehen fuenf Walze zur Auswahl.
	 *
	 * @param walzenNr : int : Walzennummer
	 */
	public void setWalzenNr(int walzenNr) {
		if ((walzenNr > 0) && (walzenNr < 6)) {
			this.walzenNr = walzenNr - 1;
		} else {
			System.err.println("Keine gültige Walzennummer");
		}
	}

	/**
	 * Setzt die Initiale Ringstellung der Walze.
	 * Es sind nur Zahlen von 1 - 26 zugelassen.
	 * <p>
	 * Die Ringstellung wird zum char umgewandelt.
	 * Im Fehlerfall wird die Ringstellung standardmaessig auf 'Z' gesetzt.
	 *
	 * @param ringstellung : int : Punkt an dem die Walze umspringt
	 */
	public void setRingstellung(int ringstellung) {
		if ((ringstellung > 0) && (ringstellung <= 26)) {
			this.ringstellung = this.alphabet.charAt(ringstellung - 1);
		} else {
			this.ringstellung = 'Z';
		}
	}

	/**
	 * * TODO: Funktionsname hat sich geändert
	 * Gibt die Grundeinstellung der Walze ein. Nur Buchstaben von A - Z sind zugelassen.
	 * Buchstaben werden automatisch in Grossbuchstaben umgewandelt.
	 * Ist die Grundeinstellung nicht 'A', wird die Methode dreheWalze() aufgerufen.
	 *
	 * @param buchstabe : Character : Einstellung der Walze
	 */
	public void setPosition(Character buchstabe) {
		this.turns = alphabet.indexOf(buchstabe);
	}
	//endregion

	//region Getter
	/**
	 * Gibt den Character zurueck, der aktuell in der Walze eingestellt ist
	 *
	 * @return Character am Index 0 des (verschobenen) Alphabets zurueck
	 */
	public Character getPosition() {
		return this.alphabet.charAt(turns % 26);
	}
	//endregion
}