package projekt.enigma.model;

/**
 * In dieser Klasse wird die Hardware zusammen gefasst.
 * Alle Komponenter der Enigma laufen hier zusammen.
 *
 * <p>
 * walzen : Walze[] :           Ist ein Array der drei eingebauten Walzen Objekte
 * steckbrett : Steckbrett :    Das Steckbrett mit den Verbindungen aus dem Codebuch
 * reflektor : Reflektor :      Dies ist das Objekt der Reflektors
 * nachricht : String :         Die verschlüsselte Nachricht wird in diesem String zusammen gesetzt und gespeichert
 * kenngruppe : String :        Früher definierte die Kennzeichnung die Einheit welche diese Enigma benutzte.
 * Wir missbrauchen die Kenngruppe für einen Benutzernamen
 * </p>
 */
public class Hardware {

    //region Variablen
    /**
     * TODO: Dokumentieren
     */
    private Walze[] walzen;
    private Steckbrett steckbrett;
    private Reflektor reflektor;
    //endregion

    //region Konstruktor
    /**
     * Im Konstruktor legen wir die Anzahl der Walzen fest welche die Hardware aufnehmen kann.
     * Die Enigma I welche hier nachgebildet werden soll, konnte drei Walzen aufnehmen.
     */
    public Hardware() {
        this.walzen = new Walze[3];
    }
    //endregion

    //region Funktionen & Methoden
    /**
     * Setzt eine Walze ein
     *
     * @param walze    : int : Setzt die Walze mit der angegebenen Nummer ein
     * @param walzenNr : int : Die Nummer der einzusetzenden Walze
     */
    public void setzeWalzenNr(int walze, int walzenNr, int ringstellung) {
        this.walzen[walze] = new Walze(walzenNr, ringstellung);
    }

    /**
     * Setzt den Notch der Walze
     *
     * @param walze    : int : Position der Walze
     * @param position : int : Umspringpunkt auf der Walze
     */
    public void setzeRing(int walze, int position) {
        this.walzen[walze].setRingstellung(position);
    }

    /**
     * Setzt den Startwert (position) der Walze (walze)
     *
     * @param walze     : int : Nummer der Walze
     * @param buchstabe : char : Buchstabe der zugewiesen soll
     */
    public void setzePosition(int walze, char buchstabe) {
        this.walzen[walze].setPosition(buchstabe);
    }

    /**
     * Verschlüsselt den übergebenen Buchstaben und fügt ihn der Nachricht hinzu
     *
     * @param buchstabe char : Der zu ver/entschlüsselnde Buchstabe
     * @return char : Der ver/entschlüsselte Buchstabe
     */
    public char codiere(char buchstabe) {

        buchstabe = Character.toUpperCase(buchstabe);
        this.dreheWalzen(1);

        buchstabe = this.steckbrett.codiere(Character.toUpperCase(buchstabe));
        buchstabe = this.walzen[2].codiere(buchstabe);
        buchstabe = this.walzen[1].codiere(buchstabe);
        buchstabe = this.walzen[0].codiere(buchstabe);
        buchstabe = this.reflektor.codiere(buchstabe);
        buchstabe = this.walzen[0].codiere2(buchstabe);
        buchstabe = this.walzen[1].codiere2(buchstabe);
        buchstabe = this.walzen[2].codiere2(buchstabe);
        buchstabe = this.steckbrett.codiere(buchstabe);

        return buchstabe;
    }

    /**
     * Nach jeder codierung eines Buchstabens müssen die Walzen gedreht werden.
     * Hier überprüfen wir welche der Walzen gedreht werden müssen und stoßen die Vorgang an.
     */
    public void dreheWalzen(int richtung) {
        if (richtung > 0) {
            for (int i = 0; i < richtung; i++) {
                if (this.walzen[2].dreheWalze(1)) {
                    if(this.walzen[1].dreheWalze(1)) {
                        this.walzen[0].dreheWalze(1);
                    }
                }
            }
        } else {
            for (int i = 0; i > richtung; richtung++) {
                if (this.walzen[2].dreheWalze(-1)) {
                    if(this.walzen[1].dreheWalze(-1)) {
                        this.walzen[0].dreheWalze(-1);
                    }
                }
            }
        }
    }

    /**
     * Diese Funktion setzt die Walzen auf ihren Anfangswert zurück.
     * Hierfür ist der Buchstabe "A" festgelegt.
     * Dies wird benötigt um zB einen neuen Spruchschlüssel einzustellen oder eine neue Nachricht zu verfassen.
     */
    public void resetWalzen() {
        this.getWalzen()[0].setPosition('A');
        this.getWalzen()[1].setPosition('A');
        this.getWalzen()[2].setPosition('A');
    }
    //endregion

    //region Setter
    /**
     * Setzt eine Walze ein und speichert das Objekt im Walzen Array
     *
     * @param position     : int : Position der Walze
     * @param walze        : int : Die Nummer der Walze
     * @param ringstellung : int : Umsprung Punkt der Walze
     */
    public void setWalzen(int position, int walze, int ringstellung) {
        this.walzen[position] = new Walze(walze, ringstellung);
    }

    /**
     * Setzt den Reflektor ein.
     * In der Enigma I welche hier nachgebaut wird, gab es nur einen Reflektor.
     * Spätere Versionen haten zwei oder mehr, deshalb haben wir hier auch schon ein Objekt dafür erstellt,
     * welches ausgetauscht werden kann.
     *
     * @param reflektor : Reflektor : Das Obejtk des Reflektors
     */
    public void setReflektor(Reflektor reflektor) {
        this.reflektor = reflektor;
    }

    /**
     * Setzt das übergebene Steckbrett Objekt in die Hardware ein
     *
     * @param steckbrett : Steckbrett : Objekt des Steckbretts mit allen verbundenen Kabeln
     */
    public void setSteckbrett(Steckbrett steckbrett) {
        this.steckbrett = steckbrett;
    }
    //endregion

    //region Getter
    /**
     * Gibt das Objekt des Steckbretts zurück
     *
     * @return Steckbrett : Das eingesetzte Steckbrett mit seinen Kabeln wenn eingesteckt
     */
    public Steckbrett getSteckbrett() {
        return steckbrett;
    }

    /**
     * Liest den Reflektor aus und gibt ihn zurück
     *
     * @return Reflektor : Objekt des Reflektors
     */
    public Reflektor getReflektor() {
        return reflektor;
    }

    /**
     * Gibt die verbauten Walzen Objekte zurück
     *
     * @return Walze[] : Array mit den Walzen Objekten
     */
    public Walze[] getWalzen() {
        return this.walzen;
    }
    //endregion

}
