package projekt.enigma.model;

import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import projekt.enigma.App;

/**
 * In dieser Klasse werden Fehler behandelt und an den User/Admin/Entwickler ausgegeben
 */
public class Fehler {

	private String functionPrefix = "- ";
	private String messagePrefix = "--> ";

	/**
	 * Zeige Fehler Dialog
	 *
	 * @param type    : String : Art der Meldung (warning/information/error)
	 * @param subject : Titel des Dialoges
	 * @param message : Nachricht der Meldung
	 */
	public void showErrorDialog(String type, String subject, String message) {
		new Fehler().debug(this.getClass().getName() + "." + new Throwable().getStackTrace()[0].getMethodName(), true);

		Alert alert;

		/* Der Titel darf auch als leerer String übergeben werden, dann wird ein Default gesetzt */
		if (subject.equals("")) {
			subject = "Es ist ein Fehler aufgetreten";
		}

		/* Welcher Fehler Typ wurde übergeben? */
		switch (type) {
			case "warning":
				alert = new Alert(AlertType.WARNING);
				break;
			case "information":
				alert = new Alert(AlertType.INFORMATION);
				break;
			case "error":
				alert = new Alert(AlertType.ERROR);
				break;
			default:
				alert = new Alert(AlertType.NONE);
		}
		/* Setzt den Titel des Dialoges */
		alert.setTitle(subject);
		/* Setzt den Headertext des Dialoges */
		alert.setHeaderText(null);
		/* Setzt die Nachricht des Dialoges */
		alert.setContentText(message);
		/* Zeige den Dialog an */
		alert.showAndWait();
	}

	public void debug(String message, boolean isFunction) {
		if (App.getDebug() != 0) {
			if (isFunction) {
				System.out.println(functionPrefix + message);
			} else {
				System.out.println(messagePrefix + message);
			}
		}
	}

	public void debug(String message, boolean isFunction, int debugLevel) {

		if (App.getDebug() != 0 && (App.getDebug() >= debugLevel || App.getDebug() == 3) ) {

			if (isFunction) {

				System.out.println(functionPrefix + message);

			} else {

				System.out.println(messagePrefix + message);

			}
		}
	}
}