package Enigma.model;

import java.time.Year;

/**
 * Klasse Walze
 * <p>
 * Erzeugt ein Objekt des Typs Walze mit den Eigenschaften:
 * <p>
 * 1. Walzennummer (Die Walze enthält die 26 Buchstaben des Alphabeths und codiert diese.
 * 5 verschiedene Walzen stehen zur Auswahl, die jeweils verschieden die Buchstaben des Alphabeths
 * paarweise vertauschen)
 * <p>
 * 2. Ringstellung (Umspringpunkt der Walze wird festgelegt. Der Umspringpunkt bestimmt
 * den Drehzeitpunkt der linken Nachbarwalze)
 */
public class Walze {

	/**
	 * Konstanten und Variablen der Klasse Walze
	 * <p>
	 * buchstabe : Bestimmt den Buchstaben
	 * ringstellung : Bestimmt den Umspringpunkt der Walze
	 * walzennr : Bestimmt die Walzennr. (also wie der Buchstabe codiert wird)
	 * iPositionBuchstabe : gibt die Position des Buchstabens auf dem Array der Walze wieder.
	 * iPositionBuchstabeRe : gibt die Position des codierten Buchstabens im Alphabet wieder.
	 * private Character[] walze : Character-Array der Walze
	 */
	/*Alphawalze*/
	private final static Character[] walzeAlpha = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
	private Character buchstabe;
	private int ringstellung;
	private int walzennr;
	private int iPositionBuchstabe;
	private Character[] walze;


	/**
	 * Gibt die Parameter der Walze mit
	 *
	 * @param walzennr     : int : Nummer der gewaehlten Walze
	 * @param ringstellung : Character : Einstellung des Notch
	 */
	public Walze(int walzennr, int ringstellung) {
		this.walze = new Character[25];
		this.walzennr = walzennr;
		this.buchstabe = 'A';
		this.iPositionBuchstabe = 0;
		this.ringstellung = ringstellung;
	}


	/**
	 * Sortiert den Walzennummern das passenden Character-Array mittels switch zu.
	 *
	 * @return walze : Character[] : gibt die gewaehlte Walze zurueck
	 */
	private Character[] walzenNummer() {

		Character[] walzeEins = {'E', 'K', 'M', 'F', 'L', 'G', 'D', 'Q', 'V', 'Z', 'N', 'T', 'O', 'W', 'Y', 'H', 'X', 'U', 'S', 'P', 'A', 'I', 'B', 'R', 'C', 'J'};
		Character[] walzeZwei = {'A', 'J', 'D', 'K', 'S', 'I', 'R', 'U', 'X', 'B', 'L', 'H', 'W', 'T', 'M', 'C', 'Q', 'G', 'Z', 'N', 'P', 'Y', 'F', 'V', 'O', 'E'};
		Character[] walzeDrei = {'B', 'D', 'F', 'H', 'J', 'L', 'C', 'P', 'R', 'T', 'X', 'V', 'Z', 'N', 'Y', 'E', 'I', 'W', 'G', 'A', 'K', 'M', 'U', 'S', 'Q', 'O'};

		Character[] walzeVier = {'E', 'S', 'O', 'V', 'P', 'Z', 'J', 'A', 'Y', 'Q', 'U', 'I', 'R', 'H', 'X', 'L', 'N', 'F', 'T', 'G', 'K', 'D', 'C', 'M', 'W', 'B'};
		Character[] walzeFuenf = {'V', 'Z', 'B', 'R', 'G', 'I', 'T', 'Y', 'U', 'P', 'S', 'D', 'N', 'H', 'L', 'X', 'A', 'W', 'M', 'J', 'Q', 'O', 'F', 'E', 'C', 'K'};

		switch (this.walzennr) {
			case 1:
				walze = walzeEins;
				break;
			case 2:
				walze = walzeZwei;
				break;
			case 3:
				walze = walzeDrei;
				break;
			case 4:
				walze = walzeVier;
				break;
			case 5:
				walze = walzeFuenf;
				break;
		}

		return walze;
	}


	//walzenPosition() return int => Gibt die aktuelle Position des Buchstabens zurück
	public char walzenPosition() {

		/*Alphabetswalze*/
		Character[] walzeAlphabeth = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

		return walzeAlphabeth[iPositionBuchstabe];
	}


	//setzeNotch(int position) => Setze Startpunkt auf int Position des Buchstabens
	// Setter für Ringstellung

	/**
	 * @return ringstellung : Character : gibt die neue Ringstellung zurueck
	 */
	public int getRingstellung() {
		return ringstellung;
	}

	/**
	 * Gibt die Initiale Ringstellung der Walze an.
	 * Es sind nur Zahlen von 1 - 26 zugelassen.
	 * Im Fehlerfall wird die Ringstellung standardmaessig auf '1' gesetzt.
	 *
	 * @param ringstellung : Character : Punkt an dem die Walze umspringt
	 */
	public void setRingstellung(int ringstellung) {

		if (ringstellung > 0 && ringstellung <= 26) {
			this.ringstellung = ringstellung;
		} else {
			this.ringstellung = 1;
		}
	}

	//dreheWalze() return boolean => Wenn Notch erreicht, gib true zurück, ansonsten false
	public boolean dreheWalze() {

		boolean checkRing;

		if (this.iPositionBuchstabe == 25) {
			this.iPositionBuchstabe = 0;
		} else {
			this.iPositionBuchstabe += 1;
		}

		checkRing = this.iPositionBuchstabe == getRingstellung();

		return checkRing;
	}


	//codiere(char buchstabe) return char => Gibt den verschlüsselten Buchstaben zurück

	/**
	 * Chiffriert den Buchstaben an der Position aus der Methode positionBuchstabe()
	 * anhand der gewaehlten Walze.
	 *
	 * @param
	 * @return chiffrierterBuchstabe : Character : chiffrierter Buchstabe
	 */
	public char codiere(char buchstabe) {
		/**
		 * TODO: contains fragt ab ob der char im Alphabet enthalten ist. Das sollten wir vielleicht noch in eine
		 * Hilfsfunktion packen. Vielleicht sogar in der Hardware Klasse.
		 */
		boolean contains = false;
		for (int i = 0; i < walzeAlpha.length; i++) {
			if (walzeAlpha[i].equals(buchstabe)) {
				buchstabe = walzenNummer()[i];
				contains = true;
				break;
			}
		}
		if(!contains) {
			buchstabe = 'X';
		}

		return buchstabe;
	}


	//codiere2(char buchstabe) => Gibt den vertauschten Buchstaben zurück (Reverse)

	/**
	 * Chiffriert den Buchstaben an der Position aus der Methode positionBuchstabeReverse()
	 * anhand der AlphaWalze.
	 *
	 * @param
	 * @return codierterBuchstabeRe : Character : chiffrierter Buchstabe
	 */
	public char codiere2(char buchstabe) {

		for (int i = 0; i < walzenNummer().length; i++) {
			if (walzenNummer()[i].equals(buchstabe)) {
				buchstabe = walzeAlpha[i];
				break;
			}
		}

		return buchstabe;
	}

//_________________________________________________________________________________________


	/**
	 * @return buchstabe : Character : gibt den neuen Buchstaben zurueck
	 */
	public Character getBuchstabe() {
		return buchstabe;
	}

	/**
	 * Gibt die Grundeinstellung der Walze ein. Nur Buchstaben von A - Z sind zugelassen.
	 * Buchstaben werden automatisch in Grossbuchstaben umgewandelt.
	 * Im Fehlerfall wird die Grundeinstellung der Walze standardmaessig auf 'A' gesetzt.
	 *
	 * @param buchstabe : Character : Grundeinstellung der Walze
	 */
	public void setBuchstabe(Character buchstabe) {

		if (Character.isLetter(buchstabe)) {
			this.buchstabe = Character.toUpperCase(buchstabe);
			for (int i = 0; i < 25; i++) {
				if (walzeAlpha[i].equals(buchstabe)) {
					this.iPositionBuchstabe = i;
				}
			}
		} else {
			this.buchstabe = 'A';
		}
	}

	//TODO: ??? Brauchen wir Setter, wo findet Überprüfung der Walzennr. statt.

	/**
	 * Definiert die Walze. Es stehen fuenf Walze zur Auswahl.
	 *
	 * @param walzennr : int : setzt die Walzennummer
	 */
	public void setWalzennr(int walzennr) {
		if (walzennr > 0 && walzennr < 6) {
			this.walzennr = walzennr;
		} else {
			System.err.println("Keine gültige Walzennummer");
		}
	}

}
