package Enigma.model;

/**
 * Klasse Reflektor
 * <p>
 * Der Reflektor nimmt einen Buchstaben der Klasse Walze entgegen und und kodiert diesen.
 * Der kodierte Buchstabe wird an die Klasse Walze wieder zurückgegeben.
 * <p>
 * Prinzipiell verhält sich die Klasse Refelktor wie die Klasse Walze, außer das sie sich
 * nach Betätigung einer Taste nicht dreht (starr montiert) und sie gibt keine Signale
 * an andere Walzen zum drehen.
 */
public class Reflektor {

    /**
     * Konstanten und Variablen der Klasse Reflektor
     * <p>
     * WALZE_ALPHABET : konstanter Char-Array mit den Werten des Alphabeths (26 Werte)
     * WALZE_REFLEKTOR : konstanter Char-Array mit den Werten des Reflektors (26 Werte)
     * reflektorBuchstabeRein : Character mit dem an die Klasse übergebenen Character
     * reflektorBuchstabeRaus : Character nach der Codierung in der Klasse Reflektor
     * iPositionReflektor : Integer mit der Positionsnummer des Characters im Array
     */
    private final Character[] WALZE_ALPHABET = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private final Character[] WALZE_REFLEKTOR = {'E', 'J', 'M', 'Z', 'A', 'L', 'Y', 'X', 'V', 'B', 'W', 'F', 'C', 'R', 'Q', 'U', 'O', 'N', 'T', 'S', 'P', 'I', 'K', 'H', 'G', 'D'};


    /**
     * Funktion Codiere
     * <p>
     * Durchsucht das konstante Char-Array WALZE_ALPHABET nach der Position eines bestimmten
     * Buchstabens und gibt den Character an der entsprechenden Position im konstanten
     * Char-Array WALZE_REFLEKTOR zurück.
     *
     * @return reflektorBuchstabeRaus: Character: Der kodierte Buchstabe aus dem Reflektor
     */
    public char codiere(Character buchstabe) {
        int iPositionReflektor = 0;

        /*Ermittelt die Position des Buchstaben buchstabe auf der Alphabetswalze*/
        for (int index = 0; index < WALZE_ALPHABET.length; index++) {
            if (buchstabe.equals(WALZE_ALPHABET[index])) {
                iPositionReflektor = index;
                break;
            }
        }
        /*Im Char-Array WALZE_REFLEKTOR wird der Character an der Position iPositionReflektor ausgegeben*/
        return WALZE_REFLEKTOR[iPositionReflektor];
    }

}
