package Enigma;

import Enigma.model.*;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.apache.http.HttpException;
import java.io.IOException;

/**
 * JavaFX App
 */
public class App extends Application {

	private static Scene scene;
	private Codierer c;

	static void setRoot(String fxml) throws IOException {
		scene.setRoot(loadFXML(fxml));
	}

	private static Parent loadFXML(String fxml) throws IOException {
		FXMLLoader fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
		return fxmlLoader.load();
	}

	public static void main(String[] args) {
		Application.launch();
	}

	@Override
	public void start(Stage stage) throws IOException {
		scene = new Scene(loadFXML("gui"));
		stage.setScene(scene);
		stage.show();

		this.c = new Codierer();

        /**
         * TODO: Nur zum Testen muss später wieder gelöscht werden.
         */
        //region Test
		c.setKenngruppe("deisold");
		String nachricht = "Hello world.";

		for (char buchstabe : nachricht.toCharArray()) {
		    if(buchstabe > 0) {
                System.out.print(buchstabe + ":");
                System.out.print(c.getHardware().codiere(buchstabe));
                System.out.println(" W1:" + c.getHardware().getWalzen()[0].getBuchstabe() + " W2:" + c.getHardware().getWalzen()[1].getBuchstabe() + " W3:" + c.getHardware().getWalzen()[2].getBuchstabe());
            }
		}
		try {
			System.out.println(c.getNachricht());
			c.sendeNachricht();
		} catch (HttpException e) {
			e.printStackTrace();
		}
		//endregion
	}

}