package projekt.enigma.model;

/**
 * TODO: Dokumentation aktuallisieren
 * <p>
 * Klasse Steckbrett
 * <br>
 * Das Steckbrett diente dazu Buchstaben paarweise zu vertauschen noch bevor diese durch die Walzen codiert werden.
 * Die Klasse Steckbrett nimmt bis zu 10 paarweise zu vertauschende Buchstabenpaare entgegen, prueft diese auf
 * Zulaessigkeit und tauscht diese dann paarweise aus.
 */
public class Steckbrett {

    /**
     * orginalBuchstaben: Character-Array, der jeweils den ersten zu vertauschenden Buchstaben enthält
     */
    private String originalBuchstaben;

    /**
     * getauschteBuchstaben: Character-Array, der jeweils den zweiten zu vertauschenden Buchstaben enthält
     */
    private String getauschteBuchstaben;


    /**
     * Konstruktor Steckbrett
     * <br>
     * Erzeugt zwei Charakter-Arrays (orginalBuchstaben und getauschteBuchstaben) der Länge 10.
     */
    public Steckbrett() {

        originalBuchstaben = "";
        getauschteBuchstaben = "";
    }

    /**
     * Funktion setzeVertauschung
     * <br>
     * Der Funktion setzeVertauschung werden 2 Buchstaben (buchstabe1 und buchstabe2) übergeben.
     * Zuerst wird überprüft ob einer der beiden Buchstaben bereits enthalten ist, was unzulässig wäre.
     * <br>
     * Anschließend wird:
     * <p>
     * buchstabe1 in das Array orginalBuchstaben auf den nächsten, freien Index geschrieben
     * buchstabe2 in das Array getauschteBuchstaben auf den nächsten, freien Index geschrieben.
     * </p>
     *
     * @param buchstabe1 : char: Gibt den ersten Buchstaben an, der getauscht werden soll.
     * @param buchstabe2 : char: gibt den zweiten Buchstaben an, mit dem der erste getauscht werden soll.
     * @return boolean : Wenn die Vertauschung zulässig ist, true, ansonsten false
     */
    public boolean setzeVertauschung(char buchstabe1, char buchstabe2) {

        if (!ueberpruefeVertauschungen(buchstabe1) && !ueberpruefeVertauschungen(buchstabe2) && originalBuchstaben.length() <= 20) {
            originalBuchstaben += buchstabe1;
            getauschteBuchstaben += buchstabe2;

            return true;
        } else {
            return false;
        }
    }

    /**
     * Funktion setzeVertauschung mit angabe eines Ports von 1 - 10
     * <br>
     * Der Funktion setzeVertauschung werden 2 Buchstaben (buchstabe1 und buchstabe2) sowie der Port übergeben.
     * Zuerst wird überprüft ob einer der beiden Buchstaben bereits enthalten ist, was unzulässig wäre.
     * <br>
     * Anschließend wird:
     * <p>
     * buchstabe1 in das Array orginalBuchstaben auf den Index (steckbrettPort) geschrieben
     * buchstabe2 in das Array getauschteBuchstaben auf den Index (steckbrettPort) geschrieben.
     * </p>
     *
     * @param buchstabe1 : char: Gibt den ersten Buchstaben an, der getauscht werden soll.
     * @param buchstabe2 : char: gibt den zweiten Buchstaben an, mit dem der erste getauscht werden soll.
     * @return boolean : Wenn die Vertauschung zulässig ist, true, ansonsten false
     */
    public boolean setzeVertauschung(int steckbrettPort, char buchstabe1, char buchstabe2) {

        if (!ueberpruefeVertauschungen(buchstabe1) && !ueberpruefeVertauschungen(buchstabe2)) {
            originalBuchstaben.replace(originalBuchstaben.charAt(steckbrettPort), buchstabe1);
            getauschteBuchstaben.replace(getauschteBuchstaben.charAt(steckbrettPort), buchstabe2);

            return true;
        } else {
            return false;
        }

    }

    /**
     * Funktion ueberpruefeVertauschungen
     * <br>
     * Die Funktion ueberpruefeVertauschungen prueft ob der übergebene Buchstabe bereits in den beiden Arrays
     * (orginalBuchstaben) und (getauschteBuchstaben) vorhanden ist.
     * Eine Buchstabenvertauschung ist zulaessig, wenn keine Dopplungen der zu vertauschenden Buchstaben auftritt
     * (ein Buchstabe nicht mehrmals vertauscht wird).
     *
     * @return boolean :    Wenn false, dann darf der Buchstabe genutzt werden.
     * Wenn er schon vorhanden ist, wird true zurück gegeben
     */
    public boolean ueberpruefeVertauschungen(Character buchstabe) {

        boolean result = false;

        if (originalBuchstaben.contains(String.valueOf(buchstabe)) ||
                getauschteBuchstaben.contains(String.valueOf(buchstabe))) {
            result = true;
        }

        return result;
    }

    /**
     * Funktion codiere
     * <br>
     * Die Funktion codiere tauscht den uebergebenen Character buchstabe mit dem zu tauschenden Character aus.
     *
     * @param buchstabe : Character : Buchstabe der codiert werden soll.
     * @return buchstabe : Character : Codierter Buchstabe.
     */
    public char codiere(Character buchstabe) {

        if (originalBuchstaben.contains(String.valueOf(buchstabe))) {
            return getauschteBuchstaben.charAt(originalBuchstaben.indexOf(buchstabe));
        } else if(getauschteBuchstaben.contains(String.valueOf(buchstabe))) {
            return originalBuchstaben.charAt(getauschteBuchstaben.indexOf(buchstabe));
        } else {
            return buchstabe;
        }
    }

}