package projekt.enigma.model;

/**
 * TODO: Dokumentation aktuallisieren
 * Klasse Reflektor
 * <br>
 * Der Reflektor nimmt einen Buchstaben der Klasse Walze entgegen und und kodiert diesen.
 * Der kodierte Buchstabe wird an die Klasse Walze wieder zurückgegeben.
 * <br>
 * Prinzipiell verhält sich die Klasse Reflektor wie die Klasse Walze, außer das sie sich
 * nach Betätigung einer Taste nicht dreht (quasi starr montiert ist) und sie gibt keine Signale
 * an andere Walzen zum drehen.
 */
public class Reflektor {

    /**
     * Funktion codiere
     * <br>
     * Durchsucht das konstante Char-Array WALZE_ALPHABET nach der Position eines bestimmten
     * Buchstabens und gibt den Character an der entsprechenden Position im konstanten
     * Char-Array WALZE_REFLEKTOR zurück.
     *
     * @return WALZE_REFLEKTOR[iPositionReflektor]: Character: Der kodierte Buchstabe aus dem Reflektor
     */
    public char codiere(Character buchstabe) {
        // alphabet : String mit den Werten des Alphabeths (26 Werte)
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        // reflektor : String mit den Werten des Reflektors (26 Werte)
        String reflektor = "EJMZALYXVBWFCRQUONTSPIKHGD";

        return reflektor.charAt(alphabet.indexOf(buchstabe));
    }
}
