package projekt.enigma.model;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/**
 * Hier sitzt der Funker.
 * Der Funkraum kann Funksprueche empfangen und senden.
 * Hierfuer wird eine Verbindung zu einem externen Service aufgebaut.
 * Dieser Servive erwartet die Nachrichten im JSON Format. Dazu wird ein k als Kenngruppe
 * (Benutzername) uebergeben und falls eine Nachricht gesendet werden soll, zusätzlich ein m mit der Nachricht.
 * Beides wird als String gesendet.
 */
public class Funkraum {

	/**
	 * Zum Empfangen liefert der Server, anstatt der Kenngruppe (k), den Empfangstag (t) der Nachricht mit, damit man
	 * die Grundeinstellungen aus dem Codebuch, für diesen Tag, raussuchen kann.
	 * {'m': 'Hello world', 't': '26'}
	 *
	 * @param kenngruppe : String : Kenngruppe dieser Enigma
	 * @return funkspruch : String[] : String Array wobei Index 0 dem Empfangstag entspricht und Index 1
	 * der empfangenen Nachricht
	 */
	public String[] empfangeFunkspruch(String kenngruppe) {
		String[] funkspruch = new String[2];

		HttpClient httpclient = HttpClients.createDefault();
		HttpPost httppost = new HttpPost("https://enigma.itstall.de/");

		try {
			// Anfrage Parameter und Encoding setzen
			List<NameValuePair> params = new ArrayList<>(2);
			params.add(new BasicNameValuePair("k", kenngruppe));
			httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

			// POST Request ausführen und Rückgabe verarbeiten
			HttpResponse response = httpclient.execute(httppost);
			HttpEntity entity = response.getEntity();

			if (entity != null) {
				BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
				JSONObject result = new JSONObject(reader.readLine());

				if (!result.getString("m").isEmpty()) {
					funkspruch[0] = result.getString("t");
					funkspruch[1] = result.getString("m");
				}
			}
		} catch (UnsupportedEncodingException e) {
			new Fehler().showErrorDialog("error", "Encoding wird nicht unterstützt",
					"Kommunikation mit dem Feind wird als Landesverrat bestraft");
		} catch (IOException e) {
			new Fehler().showErrorDialog("error", "HTTP Post war nicht erfolgreich",
					"Bitte wenden Sie sich an ihren Vorgesetzten.");
		} catch (NullPointerException e) {
			new Fehler().showErrorDialog("info", "Keiner schreibt dir...",
					"Es liegen keine neuen Nachrichten im Funkraum für Sie vor.");
		}

		return funkspruch;
	}

	/**
	 * Dem Service senden wir unsere Nachricht als POST Parameter (m) und unsere Kenngruppe (k).
	 * Dieser nimmt die Daten entgegen und hierlerlegt sie auf seinem Stapel (Datenbank) von dem die Nachrichten
	 * irgendwann, auf Anfrage, wieder abgerufen werden koennen.
	 * <p>
	 * Darauf antwortet der Server mit einem JSON Object in dem das Ergebnis der Anfrage zu sehen ist.
	 * {'result': 200}
	 * <p>
	 * Die 200 heißt hier, dass alles erfolgreich durchgefuehrt werden konnte. Steht hier etwas anderes, ist ein Fehler
	 * aufgetreten und die Anfrage war nicht erfolgreich.
	 * In letzterem Fall sollte eine Meldung an den Benutzer ausgegeben werden und ggf spaeter erneut versucht werden.
	 *
	 * @param funkspruch : String : Der zu sendende Funkspruch
	 * @param kenngruppe : String : Die Kenngruppe dieser Engima
	 * @throws IOException : Exception : Funkspruch konnte nicht gesendet werden
	 */
	public void sendeFunkspruch(String funkspruch, String kenngruppe) throws HttpException, IOException {
		HttpClient httpclient = HttpClients.createDefault();
		HttpPost httppost = new HttpPost("https://enigma.itstall.de/");

		// Anfrage Parameter und Encoding setzen
		List<NameValuePair> params = new ArrayList<>(2);
		params.add(new BasicNameValuePair("k", kenngruppe));
		params.add(new BasicNameValuePair("m", funkspruch));
		httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

		// POST Request ausführen und Rückgabe verarbeiten
		HttpResponse response = httpclient.execute(httppost);
		HttpEntity entity = response.getEntity();

		if (entity != null) {
			BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
			JSONObject result = new JSONObject(reader.readLine());
			if (result.getInt("result") != 200) {
				new Fehler().showErrorDialog("error", "HTTP Exception",
						"Der andere Funker mag deine Nachricht nicht. " +
								"Rüge ihn wenn du ihn wieder siehst...");
			}
		}
	}
}
