package projekt.enigma;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.*;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Circle;
import org.apache.http.HttpException;
import projekt.enigma.model.Codierer;
import projekt.enigma.model.Fehler;

import java.io.IOException;
import java.util.ArrayList;

public class GuiController {

    //region Klassenvariablen
    private final static String[] walzenNr = {"I", "II", "III", "IV", "V"};
    private final static String[] ringNr = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
    private final static String[] position = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private ArrayList<MenuItem> mItem;
    private String textEingabe;
    private String textCodiert;
    private boolean resetDisplay;
    private Codierer codierer;
    private char chiffrierterBuchstabe;
    //deklariert die benötigten Textfelder
    @FXML
    private TextField tfStecker1, tfStecker2, tfStecker3, tfStecker4, tfStecker5, tfStecker6, tfStecker7, tfStecker8,
            tfStecker9, tfStecker10, tfCodiert, tfKlartext;
//endregion

    //region GUI-Elemente

    //deklariert die benötigten Buttons
    @FXML
    private Button btnA, btnB, btnC, btnD, btnE, btnF, btnG, btnH, btnI, btnJ, btnK, btnL, btnM, btnN, btnO, btnP, btnQ,
            btnR, btnS, btnT, btnU, btnV, btnW, btnX, btnY, btnZ, btnSenden, btnEmpfangen, btnDelete, btnReset;
    //deklariert die benötigten Kreise
    @FXML
    private Circle circA, circB, circC, circD, circE, circF, circG, circH, circI, circJ, circK, circL, circM, circN,
            circO, circP, circQ, circR, circS, circT, circU, circV, circW, circX, circY, circZ;
    //deklariert die benötigten Label
    @FXML
    private Label lblA, lblB, lblC, lblD, lblE, lblF, lblG, lblH, lblI, lblJ, lblK, lblL, lblM, lblN, lblO, lblP, lblQ,
            lblR, lblS, lblT, lblU, lblV, lblW, lblX, lblY, lblZ, lblLadeNachricht, lblTagesschluessel,
            lblSpruchschluessel;
    //deklariert die ProgressBar
    @FXML
    private ProgressBar pbLadeNachricht;
    //deklariert die MenueButtons
    @FXML
    private MenuButton mBtnWalzPos1, mBtnWalzPos2, mBtnWalzPos3, mBtnNotchPos1, mBtnNotchPos2, mBtnNotchPos3,
            mBtnStartPos1, mBtnStartPos2, mBtnStartPos3;

//endregion

    //region Init
    /**
     * Initialisiert die Elemente GUI und setzt deren Startwerte
     */
    @FXML
    void initialize() {

        // Variablen setzen
        textEingabe = "";
        textCodiert = "";
        resetDisplay = true;

        //Einträge für Walzen
        menu(mBtnWalzPos1, walzenNr);
        menu(mBtnWalzPos2, walzenNr);
        menu(mBtnWalzPos3, walzenNr);

        //Einträge für die Ringe
        menu(mBtnNotchPos1, ringNr);
        menu(mBtnNotchPos2, ringNr);
        menu(mBtnNotchPos3, ringNr);

        //Einträge für die Startpositionen
        menu(mBtnStartPos1, position);
        menu(mBtnStartPos3, position);
        menu(mBtnStartPos2, position);
    }

    /**
     * init Methode zur Erstellung der Einträge und Action Listener für die einzelnen Menüs
     *
     * @param button : Button für die die Einträge erstellt werden sollen
     */
    private void menu(MenuButton button, String[] str) {
        mItem = new ArrayList<>();
        for (int i = 0; i < str.length; i++) {
            //Eintrag aus str der Arraylist mi hinzufügen
            mItem.add(new MenuItem(str[i]));
            //MenuItem mi dem Button button hinzufügen
            button.getItems().add(mItem.get(i));
            int finalI = i;
            //Listener für die einzelnen Einträge
            ArrayList<MenuItem> finalMi = mItem;
            mItem.get(i).setOnAction(e -> setMenuBtnText(button, finalMi.get(finalI)));
        }
    }
	//endregion

    //region EventHandler/Listener

    /**
     * Wird ausgelöst wenn der gedrückte Button losgelassen wird.
     * Setzt die Hintergrundfarbe des Kreises mit dem chiffrierten Buchstaben auf grau,
     * durch Aufruf der Methode leuchten.
     *
     * @param e => übergibt den zuletzt losgelassenen Button
     */
    @FXML
    void tasteRauf(MouseEvent e) {
        if (e.getSource() == btnA) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnB) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnC) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnD) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnE) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnF) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnG) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnH) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnI) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnJ) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnK) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnL) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnM) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnN) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnO) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnP) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnQ) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnR) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnS) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnT) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnU) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnV) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnW) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnX) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnY) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
        if (e.getSource() == btnZ) leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AUS);
    }

    /**
     * Wird ausgelöst sobald eine Taste gedrückt wird (beim drücken der Taste)
     * Auswertung welche Buchstaben-Taste gedrückt ist.
     * Übergabe des entspechenden Buchstaben als Parameter der Methode setText welche den chiffrierten Buchstaben
     * in der Klassen-Variablen chiffrierterBuchstabe ablegt.
     * Setzt die Hintergrundfarbe des Kreises mit dem chiffrierten Buchstaben auf gelb
     *
     * @param e => übergibt den momentan gedrückten Buttons
     */
    @FXML
    void tasteRunter(MouseEvent e) {
        if (e.getSource() == btnA) {
            setText(btnA);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnB) {
            setText(btnB);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnC) {
            setText(btnC);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnD) {
            setText(btnD);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnE) {
            setText(btnE);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnF) {
            setText(btnF);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnG) {
            setText(btnG);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnH) {
            setText(btnH);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnI) {
            setText(btnI);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnJ) {
            setText(btnJ);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnK) {
            setText(btnK);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnL) {
            setText(btnL);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnM) {
            setText(btnM);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnN) {
            setText(btnN);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnO) {
            setText(btnO);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnP) {
            setText(btnP);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnQ) {
            setText(btnQ);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnR) {
            setText(btnR);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnS) {
            setText(btnS);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnT) {
            setText(btnT);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnU) {
            setText(btnU);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnV) {
            setText(btnV);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnW) {
            setText(btnW);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnX) {
            setText(btnX);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnY) {
            setText(btnY);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
        if (e.getSource() == btnZ) {
            setText(btnZ);
            leuchten(chiffCircle(chiffrierterBuchstabe), BUCHSTABE_LEUCHTET.AN);
        }
    }

    /**
     * Auswertung welcher Button (senden, empfangen oder löschen) gedrückt wurde.
     * Funktionsaufruf entsprechend des gedrückten Button
     *
     * @param e => ActionEvent des auslösenden Button
     */
    @FXML
    private void gedrueckteTaste(ActionEvent e) {
        if (e.getSource() == btnSenden) {
        	if(tfCodiert.getText().equals("")) {
		        new Fehler().showErrorDialog("warning", "Haben Sie heute nichts zu sagen?",
				        "Nutzung von militärischer Infrastruktur ohne Grund ist verboten.");
	        } else {
		        sendeFunkspruch();
	        }
        }
        if (e.getSource() == btnEmpfangen) empfangeFunkspruch();
        if (e.getSource() == btnDelete) loeschen();
        if (e.getSource() == btnReset) {
            codierer.resetHardware();
            this.resetDisplay = true;
            this.setzeTagesSchluessel();
        }
    }
	//endregion

    //region Methoden
    /**
     * Setzt die Hintergrundfarbe des Kreises (chiffrierter Buchstabe) auf gelb bzw. auf grau.
     *
     * @param leuchte       => gibt an welcher Kreis (chiffrierter Buchstabe) den Hintergrund ändern soll
     * @param shiningLetter => "AN"  -> setzt Hintergrundfarbe des Kreises (chiffrierter Buchstabe) auf gelb
     *                      "AUS" -> setzt Hintergrundfarbe des Kreises (chiffrierter Buchstabe) auf grau
     */
    private void leuchten(Circle leuchte, BUCHSTABE_LEUCHTET shiningLetter) {
        if (shiningLetter == BUCHSTABE_LEUCHTET.AN) leuchte.setStyle("-fx-fill: #FFA500");
        else if (shiningLetter == BUCHSTABE_LEUCHTET.AUS) {
            leuchte.setStyle("-fx-background-color: grey");
            leuchte.setStyle("-fx-border-color:  #000000");
        }
    }

    /**
     * Gibt den Buchstabenkreis entsprechend des chiffrierten Buchstabens zurück
     *
     * @param chiffLetter => chiffrierter Buchstabe
     * @return => Kreis des chiffrierten Buchstabens (der leuchten soll)
     */
    private Circle chiffCircle(char chiffLetter) {
        switch (chiffLetter) {
            case 'A':
                return circA;
            case 'B':
                return circB;
            case 'C':
                return circC;
            case 'D':
                return circD;
            case 'E':
                return circE;
            case 'F':
                return circF;
            case 'G':
                return circG;
            case 'H':
                return circH;
            case 'I':
                return circI;
            case 'J':
                return circJ;
            case 'K':
                return circK;
            case 'L':
                return circL;
            case 'M':
                return circM;
            case 'N':
                return circN;
            case 'O':
                return circO;
            case 'P':
                return circP;
            case 'Q':
                return circQ;
            case 'R':
                return circR;
            case 'S':
                return circS;
            case 'T':
                return circT;
            case 'U':
                return circU;
            case 'V':
                return circV;
            case 'W':
                return circW;
            case 'X':
                return circX;
            case 'Y':
                return circY;
            case 'Z':
                return circZ;
        }
        return null;
    }

    /**
     * Methode zum setzen des menuButton Textes auf das ausgewählte MenuItem
     *
     * @param mBtn : MenuButton der Walze
     * @param mItm : MenuItem
     */
    private void setMenuBtnText(MenuButton mBtn, MenuItem mItm) {
        if (mBtn.getId().equals(mBtnStartPos1.getId())) setzePosition(1, mItm.getText().charAt(0));
        if (mBtn.getId().equals(mBtnStartPos2.getId())) setzePosition(2, mItm.getText().charAt(0));
        if (mBtn.getId().equals(mBtnStartPos3.getId())) setzePosition(3, mItm.getText().charAt(0));
        if (mBtn.getId().equals(mBtnWalzPos1.getId())) setzeWalze(1, mItm.getText());
        if (mBtn.getId().equals(mBtnWalzPos2.getId())) setzeWalze(2, mItm.getText());
        if (mBtn.getId().equals(mBtnWalzPos3.getId())) setzeWalze(3, mItm.getText());
        if (mBtn.getId().equals(mBtnNotchPos1.getId()))
            setzeRing(1, Integer.parseInt(mItm.getText()) - 1);
        if (mBtn.getId().equals(mBtnNotchPos2.getId()))
            setzeRing(2, Integer.parseInt(mItm.getText()) - 1);
        if (mBtn.getId().equals(mBtnNotchPos3.getId()))
            setzeRing(3, Integer.parseInt(mItm.getText()) - 1);
        tfCodiert.setText("");
        tfKlartext.setText("");
    }

    /**
     * Hier werden die TextFelder, welche die Steckverbindungen darstellen,
     * mit dem Werten die die Klasse Codierer zur Verfügung stellt gefüllt.
     */
    private void setzeSteckverbindungen() {
        tfStecker1.setText(codierer.fetchSteckverbindungen()[0][0] + "" + codierer.fetchSteckverbindungen()[0][1]);
        tfStecker2.setText(codierer.fetchSteckverbindungen()[1][0] + "" + codierer.fetchSteckverbindungen()[1][1]);
        tfStecker3.setText(codierer.fetchSteckverbindungen()[2][0] + "" + codierer.fetchSteckverbindungen()[2][1]);
        tfStecker4.setText(codierer.fetchSteckverbindungen()[3][0] + "" + codierer.fetchSteckverbindungen()[3][1]);
        tfStecker5.setText(codierer.fetchSteckverbindungen()[4][0] + "" + codierer.fetchSteckverbindungen()[4][1]);
        tfStecker6.setText(codierer.fetchSteckverbindungen()[5][0] + "" + codierer.fetchSteckverbindungen()[5][1]);
        tfStecker7.setText(codierer.fetchSteckverbindungen()[6][0] + "" + codierer.fetchSteckverbindungen()[6][1]);
        tfStecker8.setText(codierer.fetchSteckverbindungen()[7][0] + "" + codierer.fetchSteckverbindungen()[7][1]);
        tfStecker9.setText(codierer.fetchSteckverbindungen()[8][0] + "" + codierer.fetchSteckverbindungen()[8][1]);
        tfStecker10.setText(codierer.fetchSteckverbindungen()[9][0] + "" + codierer.fetchSteckverbindungen()[9][1]);
    }

    /**
     * Die Löschen Funktion löscht das letzte Zeichen im Klartext sowie im Codiert Feld,
     * der Codierer wird aufgerufen um ebenfalls das letzte Zeichen zu löschen
     */
    private void loeschen() {
        if (textEingabe.length() == 0) {
            tfKlartext.setText("");
            tfCodiert.setText("");
        } else {
            textEingabe = textEingabe.substring(0, textEingabe.length() - 1);
            textCodiert = textCodiert.substring(0, textCodiert.length() - 1);
            tfKlartext.setText(textEingabe);
            tfCodiert.setText(textCodiert);
            codierer.letztesZeichenLoeschen();
            mBtnStartPos1.setText(String.valueOf(this.codierer.fetchWalzen()[0]));
            mBtnStartPos2.setText(String.valueOf(this.codierer.fetchWalzen()[1]));
            mBtnStartPos3.setText(String.valueOf(this.codierer.fetchWalzen()[2]));
        }
    }

    /**
     * Holt Nachricht von Klasse Codierer und setzt den chiffrierten Text in das Textfeld tfCodiert,
     * sowie den Klartext in das Textfeld tfKlartext. Setzt den Spruchschlüssel
     */
    private void empfangeFunkspruch() {
        String[] empfangeneNachricht = codierer.empfangeNachricht();
        if (empfangeneNachricht[2] != null) {
            setzeTagesSchluessel();
            tfKlartext.setText(empfangeneNachricht[2]);
            tfCodiert.setText(empfangeneNachricht[1]);
            resetDisplay = true;

            // Spruchschluessel in das Feld lblSpruchschluessel schreiben
            lblSpruchschluessel.setText(codierer.empfangenerSpruchschluessel(empfangeneNachricht[2]));
        }
    }

    /**
     * Senden der Nachricht mit Hilfe der Klasse Codierer
     * Löscht die Textfelder tfKlartext und tfCodiert
     */
    private void sendeFunkspruch() {
        this.tfKlartext.setText("");
        this.tfCodiert.setText("");

        try {
            this.codierer.sendeNachricht();
        } catch (HttpException | IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * Schreibt Buchstaben des gedrückten Button in Textfeld tfKlartext.
     * Übergabe des Buchstaben vom gedrückten Button an die Klasse Codierer
     * Ablegen des chiffrierten Buchstaben in der char Variable chiffrierterBuchstabe
     * Hinzufügen des chiffrierten Buchstaben in Textfeld tfCodiert
     * Aktualisierung der Walzenstellung
     *
     * @param pressedButton : gedrückter Knopf
     */
    private void setText(Button pressedButton) {
        if (textEingabe.length() < 250) {
            if (this.resetDisplay) {
                this.tfCodiert.setText("");
                this.tfKlartext.setText("");
                this.resetDisplay = false;
                this.codierer.resetHardware();
                textCodiert = "";
                textEingabe = "";
                // Spruchschlüssel generieren und codieren
                this.codierer.generateSpruchschluessel();
                // Spruchschluessel in das Feld lblSpruchschluessel schreiben
                lblSpruchschluessel.setText(this.codierer.getSpruchschluessel());
            }
            textEingabe += pressedButton.getText();
            chiffrierterBuchstabe = codierer.codiere(pressedButton.getText().charAt(0), true);
            textCodiert += chiffrierterBuchstabe;

            tfKlartext.setText(textEingabe);
            tfCodiert.setText(textCodiert);

            // Position der Walzen aktuallisieren
            mBtnStartPos1.setText(String.valueOf(this.codierer.fetchWalzen()[0]));
            mBtnStartPos2.setText(String.valueOf(this.codierer.fetchWalzen()[1]));
            mBtnStartPos3.setText(String.valueOf(this.codierer.fetchWalzen()[2]));
        }
    }

    /**
     * Setzt die Anzeige des entsprechende Gui-Element auf die entsprechende Walze
     * ->d.h. welche Walze sitzt auf welcher Position
     *
     * @param walzeRoemischNr => gibt die Walzennummer an
     * @param walzenPosition  => gibt die Position der Walze
     */
    private void setzeWalze(int walzenPosition, String walzeRoemischNr) {
        int walzeNr = 0;
        switch (walzeRoemischNr) {
            case "I":
                walzeNr = 0;
                break;
            case "II":
                walzeNr = 1;
                break;
            case "III":
                walzeNr = 2;
                break;
            case "IV":
                walzeNr = 4;
                break;
            case "V":
                walzeNr = 4;
                break;
            default:
                break;
        }

        switch (walzenPosition) {
            case 1:
                mBtnWalzPos1.setText(walzenNr[walzeNr]);
                break;
            case 2:
                mBtnWalzPos2.setText(walzenNr[walzeNr]);
                break;
            case 3:
                mBtnWalzPos3.setText(walzenNr[walzeNr]);
                break;
            default:
                break;
        }
    }

    /**
     * Setzt die Anzeige des entsprechende Gui-Element auf die entsprechende Walze
     * -> d.h. welche Walze sitzt auf welcher Position
     *
     * @param walzenPosition => gibt die Position der Walze
     * @param walzeNr        => gibt die Walzennummer an
     */
    private void setzeWalze(int walzenPosition, int walzeNr) {
        //int walzeNr = 0;
        switch (walzeNr) {
            case 1:
                walzeNr = 0;
                break;
            case 2:
                walzeNr = 1;
                break;
            case 3:
                walzeNr = 2;
                break;
            case 4:
                walzeNr = 3;
                break;
            case 5:
                walzeNr = 4;
                break;
            default:
                break;
        }

        switch (walzenPosition) {
            case 1:
                mBtnWalzPos1.setText(walzenNr[walzeNr]);
                //codierer.setWalze(walzeNr, walzenPosition)
                break;
            case 2:
                mBtnWalzPos2.setText(walzenNr[walzeNr]);
                break;
            case 3:
                mBtnWalzPos3.setText(walzenNr[walzeNr]);
                break;
            default:
                break;
        }
    }

    /**
     * Setzt den Notch (position)=> die Mitnahmeposition der Walze (walze) fest
     * Mitnahmeposition meint => die nächste Walze wird bei erreichen dieser Position (notch)
     * um eine Stelle versetzt
     *
     * @param ringStellung   => gibt die walze an
     * @param walzenPosition => gibt den notch der Walze (walze) an
     */
    private void setzeRing(int walzenPosition, int ringStellung) {
        switch (walzenPosition) {
            case 1:
                mBtnNotchPos1.setText(ringNr[ringStellung]);
                break;
            case 2:
                mBtnNotchPos2.setText(ringNr[ringStellung]);
                break;
            case 3:
                mBtnNotchPos3.setText(ringNr[ringStellung]);
                break;
            default:
                break;
        }
    }

    /**
     * Setzt die Startposition/ aktuelle Position der Walze
     *
     * @param walze     => gibt die walze an
     * @param buchstabe gibt den Startwert bzw die aktuelle Position der Walze (walze) an
     */
    private void setzePosition(int walze, char buchstabe) {
        switch (walze) {
            case 1:
                mBtnStartPos1.setText(String.valueOf(buchstabe));
                break;
            case 2:
                mBtnStartPos2.setText(buchstabe + "");
                break;
            case 3:
                mBtnStartPos3.setText(buchstabe + "");
                break;
            default:
                break;
        }
    }

    /**
     * Setzt den aktuellen TagesSchluessel und zeigt diesen in der GUI an
     */
    private void setzeTagesSchluessel() {

        // Umsprungpunkte anzeigen
        mBtnNotchPos1.setText(String.valueOf(codierer.fetchRingstellung()[0]));
        mBtnNotchPos2.setText(String.valueOf(codierer.fetchRingstellung()[1]));
        mBtnNotchPos3.setText(String.valueOf(codierer.fetchRingstellung()[2]));

        // Walzennummern anzeigen
        setzeWalze(1, codierer.fetchWalzenNr()[0]);
        setzeWalze(2, codierer.fetchWalzenNr()[1]);
        setzeWalze(3, codierer.fetchWalzenNr()[2]);

        // Position der Walzen anzeigen
        mBtnStartPos1.setText(String.valueOf(codierer.fetchWalzen()[0]));
        mBtnStartPos2.setText(String.valueOf(codierer.fetchWalzen()[1]));
        mBtnStartPos3.setText(String.valueOf(codierer.fetchWalzen()[2]));

        // Steckbrett Felder setzen
        tfStecker1.setText(codierer.fetchSteckverbindungen()[0][0] + "" +
                codierer.fetchSteckverbindungen()[0][1]);
        tfStecker2.setText(codierer.fetchSteckverbindungen()[1][0] + "" +
                codierer.fetchSteckverbindungen()[1][1]);
        tfStecker3.setText(codierer.fetchSteckverbindungen()[2][0] + "" +
                codierer.fetchSteckverbindungen()[2][1]);
        tfStecker4.setText(codierer.fetchSteckverbindungen()[3][0] + "" +
                codierer.fetchSteckverbindungen()[3][1]);
        tfStecker5.setText(codierer.fetchSteckverbindungen()[4][0] + "" +
                codierer.fetchSteckverbindungen()[4][1]);
        tfStecker6.setText(codierer.fetchSteckverbindungen()[5][0] + "" +
                codierer.fetchSteckverbindungen()[5][1]);
        tfStecker7.setText(codierer.fetchSteckverbindungen()[6][0] + "" +
                codierer.fetchSteckverbindungen()[6][1]);
        tfStecker8.setText(codierer.fetchSteckverbindungen()[7][0] + "" +
                codierer.fetchSteckverbindungen()[7][1]);
        tfStecker9.setText(codierer.fetchSteckverbindungen()[8][0] + "" +
                codierer.fetchSteckverbindungen()[8][1]);
        tfStecker10.setText(codierer.fetchSteckverbindungen()[9][0] + "" +
                codierer.fetchSteckverbindungen()[9][1]);
        this.textCodiert = "";
        this.textEingabe = "";
        this.tfKlartext.setText("");
        this.tfCodiert.setText("");
    }

    private enum BUCHSTABE_LEUCHTET {AN, AUS}

    public void setKenngruppe(String kenngruppe) {

	    // Initialisieren des Codierers und setzen der Kenngruppe
	    codierer = new Codierer(kenngruppe);

	    this.codierer.resetHardware();

	    // Beim nächsten Tastendruck erstmal das Display löschen damit falschen Nachrichten geschickt werden.
	    resetDisplay = true;

	    // Einstellungen aus dem Logbuch auslesen und setzen
	    setzeTagesSchluessel();
	    setzeSteckverbindungen();
    }
    //endregion
}
