package projekt.enigma;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import projekt.enigma.model.Fehler;

import java.io.IOException;

/**
 * JavaFX App
 * Startklasse fuer JavaFX Application, durch die Erweiterung um die Klasse Application.
 * Baut die Benutzeroberflaeche in ihren Grundstrukturen auf.
 */
public class App extends Application {

	private static String kenngruppe;
	private static GuiController gc;
    private static int debug;
    Scene sce1, sce2;

	private static Parent loadFXML(String fxml) throws IOException {
	    FXMLLoader fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
        Parent result = fxmlLoader.load();

		if (fxml.equals("gui")) {
			gc = fxmlLoader.getController();
            gc.setKenngruppe(kenngruppe);
		}

		return result;
	}

	public static void main(String[] args) {
	    debug = 1;
		launch(args);
	}

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int debug) {
        App.debug = debug;
    }

    @Override
	public void start(Stage primaryStage) throws IOException {

		primaryStage.setTitle("Kenngruppenabfrage");

		//Scene 1
		Label label1 = new Label("Bitte Kenngruppe eingeben!");
		label1.setTranslateX(55);
		Label l1 = new Label("");
		Label l2 = new Label("");
		TextField tfield = new TextField();
		Button button1 = new Button("Kenngruppe setzen!");


	    VBox layout1 = new VBox();

	    tfield.setOnKeyPressed(e -> {
		    if (e.getCode() == KeyCode.ENTER)  {
			    if(enter(tfield.getText())) {
			    	kenngruppe = tfield.getText();

				    try {
					    primaryStage.setScene(new Scene(loadFXML("gui"), 962, 677));
				    } catch (IOException ex) {
					    ex.printStackTrace();
				    }
			    } else {
				    tfield.setStyle("-fx-background-color:#FF0000");
				    tfield.setText("Fehlerhafte Kenngruppe!");
			    }
		    }
	    });

		button1.setOnAction(e -> {
			if(enter(tfield.getText())) {
				try {
					primaryStage.setScene(new Scene(loadFXML("gui"), 962, 677));
				} catch (IOException ex) {
					ex.printStackTrace();
				}
			} else {
				tfield.setStyle("-fx-background-color:#FF0000");
				tfield.setText("Fehlerhafte Kenngruppe!");
			}
        });

		layout1.getChildren().addAll(label1, l1, tfield, l2, button1);

		sce1 = new Scene(layout1, 234, 137);

		primaryStage.setScene(sce1);
		primaryStage.show();
	}

	private boolean enter(String kenngruppe) {

		String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		boolean result = true;

		for (char c :kenngruppe.toUpperCase().toCharArray()) {
			if (!alphabet.contains(String.valueOf(c))) {
				result = false;
				break;
			}
		}
		if (kenngruppe.length() >= 9) {
			result = false;
		}

		return result;
	}


//	/**
//	 * TODO Dokumentieren
//	 */
//	private static Scene scene;
//	/**
//	 * TODO Dokumentieren
//	 *
//	 * @param fxml
//	 * @throws IOException
//	 */
//	static void setRoot(String fxml) throws IOException {
//		scene.setRoot(loadFXML(fxml));
//
//	}
//
//	/**
//	 * TODO Dokumentieren
//	 *
//	 * @param fxml
//	 * @return
//	 * @throws IOException
//	 */
//	private static Parent loadFXML(String fxml) throws IOException {
//		FXMLLoader fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
//		return fxmlLoader.load();
//	}
//
//	/**
//	 * TODO Dokumentieren
//	 *
//	 * @param args
//	 */
//	public static void main(String[] args) {
//		Application.launch();
//	}
//
//	/**
//	 * TODO Dokumentieren
//	 *
//	 * @param stage
//	 * @throws IOException
//	 */
//	@Override
//	public void start(Stage stage) throws IOException {
//		scene = new Scene(loadFXML("kenngruppe"));
//		stage.setScene(scene);
//		stage.setResizable(true);
//		stage.show();
//	}

}
