package projekt.enigma.database;

import java.sql.*;

/**
 * Dies ist die SQLite Datenbank Klasse
 * In der SQLite Datei im Resources Ordner liegt das Codebuch welches benötigt wird um die
 * Nachrichten mit der Enigma zu ver/entschlüsseln.
 * Die Datenbank ist statisch und deshalb konnte sie im Resources Ordner hinterlegt werden.
 * Für jeden Tag des Monats (1-31) ist ein eigener Eintrag enthalten welcher über die Funktion
 * getCodebuch abgerufen werden kann.
 * Zurückgegeben wird ein Array welcher in der getCodebuch Funktion genauer dokumentiert ist.
 */
public class DatenbankSqlite {

	/**
	 * Verbindung zur SQLite Datenbank aufbauen.
	 * Die Datei liegt in den Resources und ändert sich nicht,
	 * weshalb der Pfad zu derselben fest hinterlegt ist.
	 *
	 * @return conn : Connection
	 */
	private Connection connect() {

		String url = "jdbc:sqlite::resource:projekt/enigma/codebuch.sqlite";
		Connection conn = null;

		try {
			conn = DriverManager.getConnection(url);
		} catch (SQLException e) {
			e.printStackTrace();
		}

		return conn;
	}

	/**
	 * Liest das Codebuch aus der SQLite Datenbank aus
	 * Dieser Funktion muss ein tag als int Wert übergeben werden.
	 * Anschließend wir eine Verbindung zur SQLite Datenbank aufgebaut und das Codebuch angefragt.
	 * Dieses wird in ein Object vom Type Codebuch gepackt und zurück gegeben.
	 *
	 * Hole den heutigen Eintrag aus der SQLite Datenbank und erstelle daraus ein Codebuch Objekt
	 *
	 * @param tag : int : Tag für welchen ein Codebuch benötigt wird.
	 * @return String : Die Einstellungen des angefragten Tages
	 * <p>
	 *     String[0] : Tag
	 *     String[1] : Walzenlage
	 *     String[2] : Ringstellung
	 *     String[3] : Steckverbindung
	 * </p>
	 */
	public String[] getCodebuch(int tag) {

		String[] codebuch = new String[4];

		try {
			Connection conn = this.connect();
			PreparedStatement pstm = conn.prepareStatement("SELECT * FROM table_codebuch WHERE Tag=? LIMIT 1");
			pstm.setInt(1, tag);
			ResultSet rs = pstm.executeQuery();

			while (rs.next()) {
				codebuch[0] = rs.getString("Tag");
				codebuch[1] = rs.getString("Walzenlage");
				codebuch[2] = rs.getString("Ringstellung");
				codebuch[3] = rs.getString("Steckverbindung");
			}
		} catch (SQLException ignored) {
		}

		return codebuch;
	}

	//region Random New Codebuch generieren
	/**
	 * Setzt zufällige Codebuch Einträge in die SQLite Datenbank
	 * Tag => int
	 * Walzenlage => String w1,w2,w3
	 * Ringstellung => String r1,r2,r3
	 * Steckverbindungen => s0,s1,s2,s3,s4,s5,s6,s7,s8,s9
	 */
	/*
	public void autoGenCodebuch() throws SQLException {

		Connection conn = connect();
		conn.setAutoCommit(false);
		PreparedStatement pstmtInsert = conn.prepareStatement("INSERT INTO table_codebuch (Tag, Walzenlage, Ringstellung, Steckverbindung) VALUES (?, ?, ?, ?);");
		for (int i = 3; i < 32; i++) {
			pstmtInsert.setInt(1, i);
			pstmtInsert.setString(2, walzenlage());
			pstmtInsert.setString(3, ringstellung());
			pstmtInsert.setString(4, steckverbindung());
			pstmtInsert.executeUpdate();
		}

		conn.commit();
	}

	/**
	 * Generiert einen String aus 3 Zufalls-Zahlen(zwischen 1 und 5)
	 * die Zahlen sind durch Komma getrennt
	 * @return String => walzenlage mit drei Kommaseparierten Zufallszahlen zwischen 1 und 5
	 */
	/*
	private static String walzenlage(){
		String walzenlage;
		Random random = new Random();
		int[] w = new int[3];
		for (int i = 0; i < 3; i++) {

			w[i] = (random.nextInt(5))+1;
			if (i==1&&w[0]==w[i])w[i]=(random.nextInt(5))+1;
			if ((i==2&&w[0]==w[2])||(i==2&&w[1]==w[i]))w[i]=(random.nextInt(5))+1;
		}
		walzenlage= w[0]+","+w[1]+","+w[2];
		return walzenlage;
	}*/

	/**
	 * Generiert einen String aus 3 Zufalls-Zahlen(zwischen 1 und 26)
	 * die Zahlen sind durch Komma getrennt
	 * @return String => ringstellung mit drei Kommaseparierten Zufallszahlen zwischen 1 und 26
	 */
	/*
	private static String ringstellung(){
		String ringstellung;
		Random random = new Random();
		int[] w = new int[3];
		for (int i = 0; i < 3; i++) {
			w[i] = (random.nextInt(26))+1;
		}
		ringstellung= w[0]+","+w[1]+","+w[2];
		return ringstellung;
	}*/

	/**
	 * Generiert einen String aus 10 * 2 unterschiedlichen Großbuchstaben
	 * @return String => 10 Buchstabenkombinationen mit Komma getrennt
	 *//*
	    private static String steckverbindung(){
        Random rnd = new Random();
        String steckverbindung="";


        char[] c = new char[20];
        for (int i = 0; i < 20; i++) {
            c[i] = (char) (rnd.nextInt(26) + 'A');
            for (int j = i; j >= 0; j--) {
                if (i>j) {
                    while (c[i]==c[j]) {
                        c[i] = (char) (rnd.nextInt(26) + 'A');
                        j= i-1;
                    }
                }
            }
        }
        steckverbindung = ((""+c[0]) + (""+c[1]) +"," +(""+c[2]) +(""+c[3]) + ","+(""+c[4]) +(""+c[5]) + ","+(""+c[6]) +(""+c[7]) + ","
                +(""+c[8]) +(""+c[9]) + ","+(""+c[10]) +(""+c[11]) + ","+(""+c[12]) +(""+c[13]) + ","+(""+c[14]) +(""+c[15]) + ","+(""+c[16]) +(""+c[17]) + ","
                +(""+c[18]) +(""+c[19]));
       // System.out.println(steckverbindung);
       // steckverbindung= (String) steckverbindung.subSequence(0,steckverbindung.lastIndexOf(","));
        return steckverbindung;
    }*/
	//endregion
}
